<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OfficeInfo StructType
 * @subpackage Structs
 */
class OfficeInfo extends AbstractStructBase
{
    /**
     * The organization
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ItemRef
     */
    public $organization;
    /**
     * The department
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $department;
    /**
     * The title
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $title;
    /**
     * The website
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $website;
    /**
     * The profession
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $profession;
    /**
     * The location
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $location;
    /**
     * The manager
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $manager;
    /**
     * The assistant
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $assistant;
    /**
     * Constructor method for OfficeInfo
     * @uses OfficeInfo::setOrganization()
     * @uses OfficeInfo::setDepartment()
     * @uses OfficeInfo::setTitle()
     * @uses OfficeInfo::setWebsite()
     * @uses OfficeInfo::setProfession()
     * @uses OfficeInfo::setLocation()
     * @uses OfficeInfo::setManager()
     * @uses OfficeInfo::setAssistant()
     * @param \StructType\ItemRef $organization
     * @param string $department
     * @param string $title
     * @param string $website
     * @param string $profession
     * @param string $location
     * @param string $manager
     * @param string $assistant
     */
    public function __construct(\StructType\ItemRef $organization = null, $department = null, $title = null, $website = null, $profession = null, $location = null, $manager = null, $assistant = null)
    {
        $this
            ->setOrganization($organization)
            ->setDepartment($department)
            ->setTitle($title)
            ->setWebsite($website)
            ->setProfession($profession)
            ->setLocation($location)
            ->setManager($manager)
            ->setAssistant($assistant);
    }
    /**
     * Get organization value
     * @return \StructType\ItemRef|null
     */
    public function getOrganization()
    {
        return $this->organization;
    }
    /**
     * Set organization value
     * @param \StructType\ItemRef $organization
     * @return \StructType\OfficeInfo
     */
    public function setOrganization(\StructType\ItemRef $organization = null)
    {
        $this->organization = $organization;
        return $this;
    }
    /**
     * Get department value
     * @return string|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param string $department
     * @return \StructType\OfficeInfo
     */
    public function setDepartment($department = null)
    {
        // validation for constraint: string
        if (!is_null($department) && !is_string($department)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($department)), __LINE__);
        }
        $this->department = $department;
        return $this;
    }
    /**
     * Get title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \StructType\OfficeInfo
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get website value
     * @return string|null
     */
    public function getWebsite()
    {
        return $this->website;
    }
    /**
     * Set website value
     * @param string $website
     * @return \StructType\OfficeInfo
     */
    public function setWebsite($website = null)
    {
        // validation for constraint: string
        if (!is_null($website) && !is_string($website)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($website)), __LINE__);
        }
        $this->website = $website;
        return $this;
    }
    /**
     * Get profession value
     * @return string|null
     */
    public function getProfession()
    {
        return $this->profession;
    }
    /**
     * Set profession value
     * @param string $profession
     * @return \StructType\OfficeInfo
     */
    public function setProfession($profession = null)
    {
        // validation for constraint: string
        if (!is_null($profession) && !is_string($profession)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($profession)), __LINE__);
        }
        $this->profession = $profession;
        return $this;
    }
    /**
     * Get location value
     * @return string|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param string $location
     * @return \StructType\OfficeInfo
     */
    public function setLocation($location = null)
    {
        // validation for constraint: string
        if (!is_null($location) && !is_string($location)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($location)), __LINE__);
        }
        $this->location = $location;
        return $this;
    }
    /**
     * Get manager value
     * @return string|null
     */
    public function getManager()
    {
        return $this->manager;
    }
    /**
     * Set manager value
     * @param string $manager
     * @return \StructType\OfficeInfo
     */
    public function setManager($manager = null)
    {
        // validation for constraint: string
        if (!is_null($manager) && !is_string($manager)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($manager)), __LINE__);
        }
        $this->manager = $manager;
        return $this;
    }
    /**
     * Get assistant value
     * @return string|null
     */
    public function getAssistant()
    {
        return $this->assistant;
    }
    /**
     * Set assistant value
     * @param string $assistant
     * @return \StructType\OfficeInfo
     */
    public function setAssistant($assistant = null)
    {
        // validation for constraint: string
        if (!is_null($assistant) && !is_string($assistant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($assistant)), __LINE__);
        }
        $this->assistant = $assistant;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OfficeInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
