<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NotifyList StructType
 * @subpackage Structs
 */
class NotifyList extends AbstractStructBase
{
    /**
     * The entry
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NotifyEntry[]
     */
    public $entry;
    /**
     * Constructor method for NotifyList
     * @uses NotifyList::setEntry()
     * @param \StructType\NotifyEntry[] $entry
     */
    public function __construct(array $entry = array())
    {
        $this
            ->setEntry($entry);
    }
    /**
     * Get entry value
     * @return \StructType\NotifyEntry[]|null
     */
    public function getEntry()
    {
        return $this->entry;
    }
    /**
     * Set entry value
     * @throws \InvalidArgumentException
     * @param \StructType\NotifyEntry[] $entry
     * @return \StructType\NotifyList
     */
    public function setEntry(array $entry = array())
    {
        foreach ($entry as $notifyListEntryItem) {
            // validation for constraint: itemType
            if (!$notifyListEntryItem instanceof \StructType\NotifyEntry) {
                throw new \InvalidArgumentException(sprintf('The entry property can only contain items of \StructType\NotifyEntry, "%s" given', is_object($notifyListEntryItem) ? get_class($notifyListEntryItem) : gettype($notifyListEntryItem)), __LINE__);
            }
        }
        $this->entry = $entry;
        return $this;
    }
    /**
     * Add item to entry value
     * @throws \InvalidArgumentException
     * @param \StructType\NotifyEntry $item
     * @return \StructType\NotifyList
     */
    public function addToEntry(\StructType\NotifyEntry $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NotifyEntry) {
            throw new \InvalidArgumentException(sprintf('The entry property can only contain items of \StructType\NotifyEntry, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->entry[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NotifyList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
