<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NameAndEmail StructType
 * @subpackage Structs
 */
class NameAndEmail extends AbstractStructBase
{
    /**
     * The displayName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:displayName
     * @var string
     */
    public $displayName;
    /**
     * The email
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:email
     * @var string
     */
    public $email;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:uuid
     * - documentation: The UUID is the unique user ID on a given email system. This is used in various places to indicate that a sender or recipient is an user internal to the collaboration system instead of an external user (i.e. internet address).
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for NameAndEmail
     * @uses NameAndEmail::setDisplayName()
     * @uses NameAndEmail::setEmail()
     * @uses NameAndEmail::setUuid()
     * @param string $displayName
     * @param string $email
     * @param string $uuid
     */
    public function __construct($displayName = null, $email = null, $uuid = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setEmail($email)
            ->setUuid($uuid);
    }
    /**
     * Get displayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->displayName;
    }
    /**
     * Set displayName value
     * @param string $displayName
     * @return \StructType\NameAndEmail
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($displayName)), __LINE__);
        }
        $this->displayName = $displayName;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\NameAndEmail
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\NameAndEmail
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NameAndEmail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
