<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NNTPFolder StructType
 * @subpackage Structs
 */
class NNTPFolder extends Folder
{
    /**
     * The folderType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $folderType;
    /**
     * The account
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\NNTP
     */
    public $account;
    /**
     * Constructor method for NNTPFolder
     * @uses NNTPFolder::setFolderType()
     * @uses NNTPFolder::setAccount()
     * @param string $folderType
     * @param \StructType\NNTP $account
     */
    public function __construct($folderType = null, \StructType\NNTP $account = null)
    {
        $this
            ->setFolderType($folderType)
            ->setAccount($account);
    }
    /**
     * Get folderType value
     * @return string|null
     */
    public function getFolderType()
    {
        return $this->folderType;
    }
    /**
     * Set folderType value
     * @uses \EnumType\FolderType::valueIsValid()
     * @uses \EnumType\FolderType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $folderType
     * @return \StructType\NNTPFolder
     */
    public function setFolderType($folderType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FolderType::valueIsValid($folderType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $folderType, implode(', ', \EnumType\FolderType::getValidValues())), __LINE__);
        }
        $this->folderType = $folderType;
        return $this;
    }
    /**
     * Get account value
     * @return \StructType\NNTP|null
     */
    public function getAccount()
    {
        return $this->account;
    }
    /**
     * Set account value
     * @param \StructType\NNTP $account
     * @return \StructType\NNTPFolder
     */
    public function setAccount(\StructType\NNTP $account = null)
    {
        $this->account = $account;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NNTPFolder
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
