<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for moveItemRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: This method will link (copy) or move items into the container. To do a link (copy) do not supply a from container. To move item(s) from one container to another supply the from container id. To order the item in the checklist folder,
 * you can also supply the before and / or after elements. If you are just moving the item within the checklist folder, you do not supply the container element. If you supply item id's for before and after, the item will be positioned between the two
 * items. If you do not supply values for before and after, the item will be placed last in the checklist folder. There are special values used as helpers. "first" can be used in before to place the item first in the list. "last" can be placed in after
 * to place the item last in the list. The under element controls making an item a subtask item. The item referenced by id will be put under the item identified by under.
 * @subpackage Structs
 */
class MoveItemRequest extends AbstractStructBase
{
    /**
     * The container
     * Meta informations extracted from the WSDL
     * - minOccurs: 0 | 0
     * - documentation: The unique identifier is a application defined string to uniquely identify an item. The string can optionally consist of two parts. The first part identifies a unique existence of an item. The second part of the string optionally
     * specifies instance information. The first and second part of the ID are separated by an '@'. For this reason neither the first nor second part can contain an '@' symbol. To determine whether or not two items are the same item, the consumer of this
     * API should compare the first part of the ids of the two items (i.e. all of the id up to the @ symbol).
     * - pattern: [^@]+(@*)?
     * - type: xs:string
     * @var string
     */
    public $container;
    /**
     * The from
     * Meta informations extracted from the WSDL
     * - minOccurs: 0 | 0
     * - documentation: The unique identifier is a application defined string to uniquely identify an item. The string can optionally consist of two parts. The first part identifies a unique existence of an item. The second part of the string optionally
     * specifies instance information. The first and second part of the ID are separated by an '@'. For this reason neither the first nor second part can contain an '@' symbol. To determine whether or not two items are the same item, the consumer of this
     * API should compare the first part of the ids of the two items (i.e. all of the id up to the @ symbol).
     * - pattern: [^@]+(@*)?
     * - type: xs:string
     * @var string
     */
    public $from;
    /**
     * The before
     * Meta informations extracted from the WSDL
     * - minOccurs: 0 | 0
     * - documentation: The unique identifier is a application defined string to uniquely identify an item. The string can optionally consist of two parts. The first part identifies a unique existence of an item. The second part of the string optionally
     * specifies instance information. The first and second part of the ID are separated by an '@'. For this reason neither the first nor second part can contain an '@' symbol. To determine whether or not two items are the same item, the consumer of this
     * API should compare the first part of the ids of the two items (i.e. all of the id up to the @ symbol).
     * - pattern: [^@]+(@*)?
     * - type: xs:string
     * @var string
     */
    public $before;
    /**
     * The after
     * Meta informations extracted from the WSDL
     * - minOccurs: 0 | 0
     * - documentation: The unique identifier is a application defined string to uniquely identify an item. The string can optionally consist of two parts. The first part identifies a unique existence of an item. The second part of the string optionally
     * specifies instance information. The first and second part of the ID are separated by an '@'. For this reason neither the first nor second part can contain an '@' symbol. To determine whether or not two items are the same item, the consumer of this
     * API should compare the first part of the ids of the two items (i.e. all of the id up to the @ symbol).
     * - pattern: [^@]+(@*)?
     * - type: xs:string
     * @var string
     */
    public $after;
    /**
     * The under
     * Meta informations extracted from the WSDL
     * - minOccurs: 0 | 0
     * - documentation: The unique identifier is a application defined string to uniquely identify an item. The string can optionally consist of two parts. The first part identifies a unique existence of an item. The second part of the string optionally
     * specifies instance information. The first and second part of the ID are separated by an '@'. For this reason neither the first nor second part can contain an '@' symbol. To determine whether or not two items are the same item, the consumer of this
     * API should compare the first part of the ids of the two items (i.e. all of the id up to the @ symbol).
     * - pattern: [^@]+(@*)?
     * - type: xs:string
     * @var string
     */
    public $under;
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - documentation: The unique identifier is a application defined string to uniquely identify an item. The string can optionally consist of two parts. The first part identifies a unique existence of an item. The second part of the string optionally
     * specifies instance information. The first and second part of the ID are separated by an '@'. For this reason neither the first nor second part can contain an '@' symbol. To determine whether or not two items are the same item, the consumer of this
     * API should compare the first part of the ids of the two items (i.e. all of the id up to the @ symbol).
     * - minOccurs: 0
     * - pattern: [^@]+(@*)?
     * - type: xs:string
     * @var string
     */
    public $id;
    /**
     * The recurrenceAllInstances
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $recurrenceAllInstances;
    /**
     * Constructor method for moveItemRequest
     * @uses MoveItemRequest::setContainer()
     * @uses MoveItemRequest::setFrom()
     * @uses MoveItemRequest::setBefore()
     * @uses MoveItemRequest::setAfter()
     * @uses MoveItemRequest::setUnder()
     * @uses MoveItemRequest::setId()
     * @uses MoveItemRequest::setRecurrenceAllInstances()
     * @param string $container
     * @param string $from
     * @param string $before
     * @param string $after
     * @param string $under
     * @param string $id
     * @param int $recurrenceAllInstances
     */
    public function __construct($container = null, $from = null, $before = null, $after = null, $under = null, $id = null, $recurrenceAllInstances = null)
    {
        $this
            ->setContainer($container)
            ->setFrom($from)
            ->setBefore($before)
            ->setAfter($after)
            ->setUnder($under)
            ->setId($id)
            ->setRecurrenceAllInstances($recurrenceAllInstances);
    }
    /**
     * Get container value
     * @return string
     */
    public function getContainer()
    {
        return $this->container;
    }
    /**
     * Set container value
     * @param string $container
     * @return \StructType\MoveItemRequest
     */
    public function setContainer($container = null)
    {
        // validation for constraint: pattern
        if (is_scalar($container) && !preg_match('/[^@]+(@*)?/', $container)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[^@]+(@*)?", "%s" given', var_export($container, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($container) && !is_string($container)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($container)), __LINE__);
        }
        $this->container = $container;
        return $this;
    }
    /**
     * Get from value
     * @return string
     */
    public function getFrom()
    {
        return $this->from;
    }
    /**
     * Set from value
     * @param string $from
     * @return \StructType\MoveItemRequest
     */
    public function setFrom($from = null)
    {
        // validation for constraint: pattern
        if (is_scalar($from) && !preg_match('/[^@]+(@*)?/', $from)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[^@]+(@*)?", "%s" given', var_export($from, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($from) && !is_string($from)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($from)), __LINE__);
        }
        $this->from = $from;
        return $this;
    }
    /**
     * Get before value
     * @return string
     */
    public function getBefore()
    {
        return $this->before;
    }
    /**
     * Set before value
     * @param string $before
     * @return \StructType\MoveItemRequest
     */
    public function setBefore($before = null)
    {
        // validation for constraint: pattern
        if (is_scalar($before) && !preg_match('/[^@]+(@*)?/', $before)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[^@]+(@*)?", "%s" given', var_export($before, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($before) && !is_string($before)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($before)), __LINE__);
        }
        $this->before = $before;
        return $this;
    }
    /**
     * Get after value
     * @return string
     */
    public function getAfter()
    {
        return $this->after;
    }
    /**
     * Set after value
     * @param string $after
     * @return \StructType\MoveItemRequest
     */
    public function setAfter($after = null)
    {
        // validation for constraint: pattern
        if (is_scalar($after) && !preg_match('/[^@]+(@*)?/', $after)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[^@]+(@*)?", "%s" given', var_export($after, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($after) && !is_string($after)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($after)), __LINE__);
        }
        $this->after = $after;
        return $this;
    }
    /**
     * Get under value
     * @return string
     */
    public function getUnder()
    {
        return $this->under;
    }
    /**
     * Set under value
     * @param string $under
     * @return \StructType\MoveItemRequest
     */
    public function setUnder($under = null)
    {
        // validation for constraint: pattern
        if (is_scalar($under) && !preg_match('/[^@]+(@*)?/', $under)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[^@]+(@*)?", "%s" given', var_export($under, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($under) && !is_string($under)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($under)), __LINE__);
        }
        $this->under = $under;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\MoveItemRequest
     */
    public function setId($id = null)
    {
        // validation for constraint: pattern
        if (is_scalar($id) && !preg_match('/[^@]+(@*)?/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[^@]+(@*)?", "%s" given', var_export($id, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get recurrenceAllInstances value
     * @return int|null
     */
    public function getRecurrenceAllInstances()
    {
        return $this->recurrenceAllInstances;
    }
    /**
     * Set recurrenceAllInstances value
     * @param int $recurrenceAllInstances
     * @return \StructType\MoveItemRequest
     */
    public function setRecurrenceAllInstances($recurrenceAllInstances = null)
    {
        // validation for constraint: int
        if (!is_null($recurrenceAllInstances) && !is_numeric($recurrenceAllInstances)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($recurrenceAllInstances)), __LINE__);
        }
        $this->recurrenceAllInstances = $recurrenceAllInstances;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MoveItemRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
