<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MonthList StructType
 * @subpackage Structs
 */
class MonthList extends AbstractStructBase
{
    /**
     * The month
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - maxInclusive: 11
     * @var string[]
     */
    public $month;
    /**
     * Constructor method for MonthList
     * @uses MonthList::setMonth()
     * @param string[] $month
     */
    public function __construct(array $month = array())
    {
        $this
            ->setMonth($month);
    }
    /**
     * Get month value
     * @return string[]|null
     */
    public function getMonth()
    {
        return $this->month;
    }
    /**
     * Set month value
     * @throws \InvalidArgumentException
     * @param string[] $month
     * @return \StructType\MonthList
     */
    public function setMonth(array $month = array())
    {
        // validation for constraint: maxInclusive
        if ($month > 11) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 11, "%s" given', $month), __LINE__);
        }
        foreach ($month as $monthListMonthItem) {
            // validation for constraint: itemType
            if (!is_string($monthListMonthItem)) {
                throw new \InvalidArgumentException(sprintf('The month property can only contain items of unsignedByte, "%s" given', is_object($monthListMonthItem) ? get_class($monthListMonthItem) : gettype($monthListMonthItem)), __LINE__);
            }
        }
        $this->month = $month;
        return $this;
    }
    /**
     * Add item to month value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\MonthList
     */
    public function addToMonth($item)
    {
        // validation for constraint: maxInclusive
        if ($item > 11) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 11, "%s" given', $item), __LINE__);
        }
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The month property can only contain items of unsignedByte, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->month[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MonthList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
