<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for modifyItemsRequest StructType
 * @subpackage Structs
 */
class ModifyItemsRequest extends AbstractStructBase
{
    /**
     * The item
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\ModifyItem[]
     */
    public $item;
    /**
     * Constructor method for modifyItemsRequest
     * @uses ModifyItemsRequest::setItem()
     * @param \StructType\ModifyItem[] $item
     */
    public function __construct(array $item = array())
    {
        $this
            ->setItem($item);
    }
    /**
     * Get item value
     * @return \StructType\ModifyItem[]|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * Set item value
     * @throws \InvalidArgumentException
     * @param \StructType\ModifyItem[] $item
     * @return \StructType\ModifyItemsRequest
     */
    public function setItem(array $item = array())
    {
        foreach ($item as $modifyItemsRequestItemItem) {
            // validation for constraint: itemType
            if (!$modifyItemsRequestItemItem instanceof \StructType\ModifyItem) {
                throw new \InvalidArgumentException(sprintf('The item property can only contain items of \StructType\ModifyItem, "%s" given', is_object($modifyItemsRequestItemItem) ? get_class($modifyItemsRequestItemItem) : gettype($modifyItemsRequestItemItem)), __LINE__);
            }
        }
        $this->item = $item;
        return $this;
    }
    /**
     * Add item to item value
     * @throws \InvalidArgumentException
     * @param \StructType\ModifyItem $item
     * @return \StructType\ModifyItemsRequest
     */
    public function addToItem(\StructType\ModifyItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ModifyItem) {
            throw new \InvalidArgumentException(sprintf('The item property can only contain items of \StructType\ModifyItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->item[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ModifyItemsRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
