<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for modifyItemRequest StructType
 * @subpackage Structs
 */
class ModifyItemRequest extends AbstractStructBase
{
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - documentation: The unique identifier is a application defined string to uniquely identify an item. The string can optionally consist of two parts. The first part identifies a unique existence of an item. The second part of the string optionally
     * specifies instance information. The first and second part of the ID are separated by an '@'. For this reason neither the first nor second part can contain an '@' symbol. To determine whether or not two items are the same item, the consumer of this
     * API should compare the first part of the ids of the two items (i.e. all of the id up to the @ symbol).
     * - minOccurs: 0
     * - pattern: [^@]+(@*)?
     * - type: xs:string
     * @var string
     */
    public $id;
    /**
     * The notification
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SharedFolderNotification
     */
    public $notification;
    /**
     * The updates
     * @var \StructType\ItemChanges
     */
    public $updates;
    /**
     * The recurrenceAllInstances
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $recurrenceAllInstances;
    /**
     * Constructor method for modifyItemRequest
     * @uses ModifyItemRequest::setId()
     * @uses ModifyItemRequest::setNotification()
     * @uses ModifyItemRequest::setUpdates()
     * @uses ModifyItemRequest::setRecurrenceAllInstances()
     * @param string $id
     * @param \StructType\SharedFolderNotification $notification
     * @param \StructType\ItemChanges $updates
     * @param int $recurrenceAllInstances
     */
    public function __construct($id = null, \StructType\SharedFolderNotification $notification = null, \StructType\ItemChanges $updates = null, $recurrenceAllInstances = null)
    {
        $this
            ->setId($id)
            ->setNotification($notification)
            ->setUpdates($updates)
            ->setRecurrenceAllInstances($recurrenceAllInstances);
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\ModifyItemRequest
     */
    public function setId($id = null)
    {
        // validation for constraint: pattern
        if (is_scalar($id) && !preg_match('/[^@]+(@*)?/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[^@]+(@*)?", "%s" given', var_export($id, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get notification value
     * @return \StructType\SharedFolderNotification|null
     */
    public function getNotification()
    {
        return $this->notification;
    }
    /**
     * Set notification value
     * @param \StructType\SharedFolderNotification $notification
     * @return \StructType\ModifyItemRequest
     */
    public function setNotification(\StructType\SharedFolderNotification $notification = null)
    {
        $this->notification = $notification;
        return $this;
    }
    /**
     * Get updates value
     * @return \StructType\ItemChanges|null
     */
    public function getUpdates()
    {
        return $this->updates;
    }
    /**
     * Set updates value
     * @param \StructType\ItemChanges $updates
     * @return \StructType\ModifyItemRequest
     */
    public function setUpdates(\StructType\ItemChanges $updates = null)
    {
        $this->updates = $updates;
        return $this;
    }
    /**
     * Get recurrenceAllInstances value
     * @return int|null
     */
    public function getRecurrenceAllInstances()
    {
        return $this->recurrenceAllInstances;
    }
    /**
     * Set recurrenceAllInstances value
     * @param int $recurrenceAllInstances
     * @return \StructType\ModifyItemRequest
     */
    public function setRecurrenceAllInstances($recurrenceAllInstances = null)
    {
        // validation for constraint: int
        if (!is_null($recurrenceAllInstances) && !is_numeric($recurrenceAllInstances)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($recurrenceAllInstances)), __LINE__);
        }
        $this->recurrenceAllInstances = $recurrenceAllInstances;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ModifyItemRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
