<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MessageBody StructType
 * @subpackage Structs
 */
class MessageBody extends AbstractStructBase
{
    /**
     * The part
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\MessagePart[]
     */
    public $part;
    /**
     * Constructor method for MessageBody
     * @uses MessageBody::setPart()
     * @param \StructType\MessagePart[] $part
     */
    public function __construct(array $part = array())
    {
        $this
            ->setPart($part);
    }
    /**
     * Get part value
     * @return \StructType\MessagePart[]|null
     */
    public function getPart()
    {
        return $this->part;
    }
    /**
     * Set part value
     * @throws \InvalidArgumentException
     * @param \StructType\MessagePart[] $part
     * @return \StructType\MessageBody
     */
    public function setPart(array $part = array())
    {
        foreach ($part as $messageBodyPartItem) {
            // validation for constraint: itemType
            if (!$messageBodyPartItem instanceof \StructType\MessagePart) {
                throw new \InvalidArgumentException(sprintf('The part property can only contain items of \StructType\MessagePart, "%s" given', is_object($messageBodyPartItem) ? get_class($messageBodyPartItem) : gettype($messageBodyPartItem)), __LINE__);
            }
        }
        $this->part = $part;
        return $this;
    }
    /**
     * Add item to part value
     * @throws \InvalidArgumentException
     * @param \StructType\MessagePart $item
     * @return \StructType\MessageBody
     */
    public function addToPart(\StructType\MessagePart $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MessagePart) {
            throw new \InvalidArgumentException(sprintf('The part property can only contain items of \StructType\MessagePart, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->part[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MessageBody
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
