<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for loginRequest StructType
 * Meta informations extracted from the WSDL
 * - minOccurs: 0
 * - type: types:LoginFlags
 * @subpackage Structs
 */
class LoginRequest extends AbstractStructBase
{
    /**
     * The auth
     * @var \StructType\Authentication
     */
    public $auth;
    /**
     * The language
     * @var string
     */
    public $language;
    /**
     * The version
     * @var float
     */
    public $version;
    /**
     * The application
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $application;
    /**
     * The userid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $userid;
    /**
     * The system
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $system;
    /**
     * Constructor method for loginRequest
     * @uses LoginRequest::setAuth()
     * @uses LoginRequest::setLanguage()
     * @uses LoginRequest::setVersion()
     * @uses LoginRequest::setApplication()
     * @uses LoginRequest::setUserid()
     * @uses LoginRequest::setSystem()
     * @param \StructType\Authentication $auth
     * @param string $language
     * @param float $version
     * @param string $application
     * @param bool $userid
     * @param bool $system
     */
    public function __construct(\StructType\Authentication $auth = null, $language = null, $version = null, $application = null, $userid = null, $system = null)
    {
        $this
            ->setAuth($auth)
            ->setLanguage($language)
            ->setVersion($version)
            ->setApplication($application)
            ->setUserid($userid)
            ->setSystem($system);
    }
    /**
     * Get auth value
     * @return \StructType\Authentication|null
     */
    public function getAuth()
    {
        return $this->auth;
    }
    /**
     * Set auth value
     * @param \StructType\Authentication $auth
     * @return \StructType\LoginRequest
     */
    public function setAuth(\StructType\Authentication $auth = null)
    {
        $this->auth = $auth;
        return $this;
    }
    /**
     * Get language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->language;
    }
    /**
     * Set language value
     * @param string $language
     * @return \StructType\LoginRequest
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($language)), __LINE__);
        }
        $this->language = $language;
        return $this;
    }
    /**
     * Get version value
     * @return float|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param float $version
     * @return \StructType\LoginRequest
     */
    public function setVersion($version = null)
    {
        $this->version = $version;
        return $this;
    }
    /**
     * Get application value
     * @return string|null
     */
    public function getApplication()
    {
        return $this->application;
    }
    /**
     * Set application value
     * @param string $application
     * @return \StructType\LoginRequest
     */
    public function setApplication($application = null)
    {
        // validation for constraint: string
        if (!is_null($application) && !is_string($application)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($application)), __LINE__);
        }
        $this->application = $application;
        return $this;
    }
    /**
     * Get userid value
     * @return bool|null
     */
    public function getUserid()
    {
        return $this->userid;
    }
    /**
     * Set userid value
     * @param bool $userid
     * @return \StructType\LoginRequest
     */
    public function setUserid($userid = null)
    {
        // validation for constraint: boolean
        if (!is_null($userid) && !is_bool($userid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($userid)), __LINE__);
        }
        $this->userid = $userid;
        return $this;
    }
    /**
     * Get system value
     * @return bool|null
     */
    public function getSystem()
    {
        return $this->system;
    }
    /**
     * Set system value
     * @param bool $system
     * @return \StructType\LoginRequest
     */
    public function setSystem($system = null)
    {
        // validation for constraint: boolean
        if (!is_null($system) && !is_bool($system)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($system)), __LINE__);
        }
        $this->system = $system;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LoginRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
