<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LibraryList StructType
 * @subpackage Structs
 */
class LibraryList extends AbstractStructBase
{
    /**
     * The library
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Library[]
     */
    public $library;
    /**
     * Constructor method for LibraryList
     * @uses LibraryList::setLibrary()
     * @param \StructType\Library[] $library
     */
    public function __construct(array $library = array())
    {
        $this
            ->setLibrary($library);
    }
    /**
     * Get library value
     * @return \StructType\Library[]|null
     */
    public function getLibrary()
    {
        return $this->library;
    }
    /**
     * Set library value
     * @throws \InvalidArgumentException
     * @param \StructType\Library[] $library
     * @return \StructType\LibraryList
     */
    public function setLibrary(array $library = array())
    {
        foreach ($library as $libraryListLibraryItem) {
            // validation for constraint: itemType
            if (!$libraryListLibraryItem instanceof \StructType\Library) {
                throw new \InvalidArgumentException(sprintf('The library property can only contain items of \StructType\Library, "%s" given', is_object($libraryListLibraryItem) ? get_class($libraryListLibraryItem) : gettype($libraryListLibraryItem)), __LINE__);
            }
        }
        $this->library = $library;
        return $this;
    }
    /**
     * Add item to library value
     * @throws \InvalidArgumentException
     * @param \StructType\Library $item
     * @return \StructType\LibraryList
     */
    public function addToLibrary(\StructType\Library $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Library) {
            throw new \InvalidArgumentException(sprintf('The library property can only contain items of \StructType\Library, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->library[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LibraryList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
