<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JunkHandlingList StructType
 * @subpackage Structs
 */
class JunkHandlingList extends AbstractStructBase
{
    /**
     * The entry
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JunkEntry[]
     */
    public $entry;
    /**
     * Constructor method for JunkHandlingList
     * @uses JunkHandlingList::setEntry()
     * @param \StructType\JunkEntry[] $entry
     */
    public function __construct(array $entry = array())
    {
        $this
            ->setEntry($entry);
    }
    /**
     * Get entry value
     * @return \StructType\JunkEntry[]|null
     */
    public function getEntry()
    {
        return $this->entry;
    }
    /**
     * Set entry value
     * @throws \InvalidArgumentException
     * @param \StructType\JunkEntry[] $entry
     * @return \StructType\JunkHandlingList
     */
    public function setEntry(array $entry = array())
    {
        foreach ($entry as $junkHandlingListEntryItem) {
            // validation for constraint: itemType
            if (!$junkHandlingListEntryItem instanceof \StructType\JunkEntry) {
                throw new \InvalidArgumentException(sprintf('The entry property can only contain items of \StructType\JunkEntry, "%s" given', is_object($junkHandlingListEntryItem) ? get_class($junkHandlingListEntryItem) : gettype($junkHandlingListEntryItem)), __LINE__);
            }
        }
        $this->entry = $entry;
        return $this;
    }
    /**
     * Add item to entry value
     * @throws \InvalidArgumentException
     * @param \StructType\JunkEntry $item
     * @return \StructType\JunkHandlingList
     */
    public function addToEntry(\StructType\JunkEntry $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JunkEntry) {
            throw new \InvalidArgumentException(sprintf('The entry property can only contain items of \StructType\JunkEntry, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->entry[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JunkHandlingList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
