<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemStatus StructType
 * @subpackage Structs
 */
class ItemStatus extends AbstractStructBase
{
    /**
     * The accepted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $accepted;
    /**
     * The completed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $completed;
    /**
     * The delegated
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $delegated;
    /**
     * The deleted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $deleted;
    /**
     * The forwarded
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $forwarded;
    /**
     * The private
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $private;
    /**
     * The opened
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $opened;
    /**
     * The read
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $read;
    /**
     * The replied
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $replied;
    /**
     * Constructor method for ItemStatus
     * @uses ItemStatus::setAccepted()
     * @uses ItemStatus::setCompleted()
     * @uses ItemStatus::setDelegated()
     * @uses ItemStatus::setDeleted()
     * @uses ItemStatus::setForwarded()
     * @uses ItemStatus::setPrivate()
     * @uses ItemStatus::setOpened()
     * @uses ItemStatus::setRead()
     * @uses ItemStatus::setReplied()
     * @param bool $accepted
     * @param bool $completed
     * @param bool $delegated
     * @param bool $deleted
     * @param bool $forwarded
     * @param bool $private
     * @param bool $opened
     * @param bool $read
     * @param bool $replied
     */
    public function __construct($accepted = null, $completed = null, $delegated = null, $deleted = null, $forwarded = null, $private = null, $opened = null, $read = null, $replied = null)
    {
        $this
            ->setAccepted($accepted)
            ->setCompleted($completed)
            ->setDelegated($delegated)
            ->setDeleted($deleted)
            ->setForwarded($forwarded)
            ->setPrivate($private)
            ->setOpened($opened)
            ->setRead($read)
            ->setReplied($replied);
    }
    /**
     * Get accepted value
     * @return bool|null
     */
    public function getAccepted()
    {
        return $this->accepted;
    }
    /**
     * Set accepted value
     * @param bool $accepted
     * @return \StructType\ItemStatus
     */
    public function setAccepted($accepted = null)
    {
        // validation for constraint: boolean
        if (!is_null($accepted) && !is_bool($accepted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($accepted)), __LINE__);
        }
        $this->accepted = $accepted;
        return $this;
    }
    /**
     * Get completed value
     * @return bool|null
     */
    public function getCompleted()
    {
        return $this->completed;
    }
    /**
     * Set completed value
     * @param bool $completed
     * @return \StructType\ItemStatus
     */
    public function setCompleted($completed = null)
    {
        // validation for constraint: boolean
        if (!is_null($completed) && !is_bool($completed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($completed)), __LINE__);
        }
        $this->completed = $completed;
        return $this;
    }
    /**
     * Get delegated value
     * @return bool|null
     */
    public function getDelegated()
    {
        return $this->delegated;
    }
    /**
     * Set delegated value
     * @param bool $delegated
     * @return \StructType\ItemStatus
     */
    public function setDelegated($delegated = null)
    {
        // validation for constraint: boolean
        if (!is_null($delegated) && !is_bool($delegated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($delegated)), __LINE__);
        }
        $this->delegated = $delegated;
        return $this;
    }
    /**
     * Get deleted value
     * @return bool|null
     */
    public function getDeleted()
    {
        return $this->deleted;
    }
    /**
     * Set deleted value
     * @param bool $deleted
     * @return \StructType\ItemStatus
     */
    public function setDeleted($deleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($deleted) && !is_bool($deleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($deleted)), __LINE__);
        }
        $this->deleted = $deleted;
        return $this;
    }
    /**
     * Get forwarded value
     * @return bool|null
     */
    public function getForwarded()
    {
        return $this->forwarded;
    }
    /**
     * Set forwarded value
     * @param bool $forwarded
     * @return \StructType\ItemStatus
     */
    public function setForwarded($forwarded = null)
    {
        // validation for constraint: boolean
        if (!is_null($forwarded) && !is_bool($forwarded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($forwarded)), __LINE__);
        }
        $this->forwarded = $forwarded;
        return $this;
    }
    /**
     * Get private value
     * @return bool|null
     */
    public function getPrivate()
    {
        return $this->private;
    }
    /**
     * Set private value
     * @param bool $private
     * @return \StructType\ItemStatus
     */
    public function setPrivate($private = null)
    {
        // validation for constraint: boolean
        if (!is_null($private) && !is_bool($private)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($private)), __LINE__);
        }
        $this->private = $private;
        return $this;
    }
    /**
     * Get opened value
     * @return bool|null
     */
    public function getOpened()
    {
        return $this->opened;
    }
    /**
     * Set opened value
     * @param bool $opened
     * @return \StructType\ItemStatus
     */
    public function setOpened($opened = null)
    {
        // validation for constraint: boolean
        if (!is_null($opened) && !is_bool($opened)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($opened)), __LINE__);
        }
        $this->opened = $opened;
        return $this;
    }
    /**
     * Get read value
     * @return bool|null
     */
    public function getRead()
    {
        return $this->read;
    }
    /**
     * Set read value
     * @param bool $read
     * @return \StructType\ItemStatus
     */
    public function setRead($read = null)
    {
        // validation for constraint: boolean
        if (!is_null($read) && !is_bool($read)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($read)), __LINE__);
        }
        $this->read = $read;
        return $this;
    }
    /**
     * Get replied value
     * @return bool|null
     */
    public function getReplied()
    {
        return $this->replied;
    }
    /**
     * Set replied value
     * @param bool $replied
     * @return \StructType\ItemStatus
     */
    public function setReplied($replied = null)
    {
        // validation for constraint: boolean
        if (!is_null($replied) && !is_bool($replied)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($replied)), __LINE__);
        }
        $this->replied = $replied;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ItemStatus
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
