<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemList StructType
 * @subpackage Structs
 */
class ItemList extends AbstractStructBase
{
    /**
     * The item
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Item[]
     */
    public $item;
    /**
     * The offset
     * @var int
     */
    public $offset;
    /**
     * The count
     * @var int
     */
    public $count;
    /**
     * Constructor method for ItemList
     * @uses ItemList::setItem()
     * @uses ItemList::setOffset()
     * @uses ItemList::setCount()
     * @param \StructType\Item[] $item
     * @param int $offset
     * @param int $count
     */
    public function __construct(array $item = array(), $offset = null, $count = null)
    {
        $this
            ->setItem($item)
            ->setOffset($offset)
            ->setCount($count);
    }
    /**
     * Get item value
     * @return \StructType\Item[]|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * Set item value
     * @throws \InvalidArgumentException
     * @param \StructType\Item[] $item
     * @return \StructType\ItemList
     */
    public function setItem(array $item = array())
    {
        foreach ($item as $itemListItemItem) {
            // validation for constraint: itemType
            if (!$itemListItemItem instanceof \StructType\Item) {
                throw new \InvalidArgumentException(sprintf('The item property can only contain items of \StructType\Item, "%s" given', is_object($itemListItemItem) ? get_class($itemListItemItem) : gettype($itemListItemItem)), __LINE__);
            }
        }
        $this->item = $item;
        return $this;
    }
    /**
     * Add item to item value
     * @throws \InvalidArgumentException
     * @param \StructType\Item $item
     * @return \StructType\ItemList
     */
    public function addToItem(\StructType\Item $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Item) {
            throw new \InvalidArgumentException(sprintf('The item property can only contain items of \StructType\Item, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->item[] = $item;
        return $this;
    }
    /**
     * Get offset value
     * @return int|null
     */
    public function getOffset()
    {
        return $this->offset;
    }
    /**
     * Set offset value
     * @param int $offset
     * @return \StructType\ItemList
     */
    public function setOffset($offset = null)
    {
        // validation for constraint: int
        if (!is_null($offset) && !is_numeric($offset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($offset)), __LINE__);
        }
        $this->offset = $offset;
        return $this;
    }
    /**
     * Get count value
     * @return int|null
     */
    public function getCount()
    {
        return $this->count;
    }
    /**
     * Set count value
     * @param int $count
     * @return \StructType\ItemList
     */
    public function setCount($count = null)
    {
        // validation for constraint: int
        if (!is_null($count) && !is_numeric($count)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($count)), __LINE__);
        }
        $this->count = $count;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ItemList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
