<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Item StructType
 * Meta informations extracted from the WSDL
 * - minOccurs: 0
 * - type: xs:int
 * @subpackage Structs
 */
class Item extends AbstractStructBase
{
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0 | 0
     * - ref: tns:id
     * - documentation: The unique identifier is a application defined string to uniquely identify an item. The string can optionally consist of two parts. The first part identifies a unique existence of an item. The second part of the string optionally
     * specifies instance information. The first and second part of the ID are separated by an '@'. For this reason neither the first nor second part can contain an '@' symbol. To determine whether or not two items are the same item, the consumer of this
     * API should compare the first part of the ids of the two items (i.e. all of the id up to the @ symbol).
     * - pattern: [^@]+(@*)?
     * - type: xs:string
     * @var string
     */
    public $id;
    /**
     * The sid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:sid
     * @var int
     */
    public $sid;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:name
     * @var string
     */
    public $name;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:version
     * @var int
     */
    public $version;
    /**
     * The modified
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:modified
     * @var string
     */
    public $modified;
    /**
     * The changes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ItemChanges
     */
    public $changes;
    /**
     * Constructor method for Item
     * @uses Item::setId()
     * @uses Item::setSid()
     * @uses Item::setName()
     * @uses Item::setVersion()
     * @uses Item::setModified()
     * @uses Item::setChanges()
     * @param string $id
     * @param int $sid
     * @param string $name
     * @param int $version
     * @param string $modified
     * @param \StructType\ItemChanges $changes
     */
    public function __construct($id = null, $sid = null, $name = null, $version = null, $modified = null, \StructType\ItemChanges $changes = null)
    {
        $this
            ->setId($id)
            ->setSid($sid)
            ->setName($name)
            ->setVersion($version)
            ->setModified($modified)
            ->setChanges($changes);
    }
    /**
     * Get id value
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\Item
     */
    public function setId($id = null)
    {
        // validation for constraint: pattern
        if (is_scalar($id) && !preg_match('/[^@]+(@*)?/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[^@]+(@*)?", "%s" given', var_export($id, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get sid value
     * @return int|null
     */
    public function getSid()
    {
        return $this->sid;
    }
    /**
     * Set sid value
     * @param int $sid
     * @return \StructType\Item
     */
    public function setSid($sid = null)
    {
        // validation for constraint: int
        if (!is_null($sid) && !is_numeric($sid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sid)), __LINE__);
        }
        $this->sid = $sid;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\Item
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get version value
     * @return int|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param int $version
     * @return \StructType\Item
     */
    public function setVersion($version = null)
    {
        // validation for constraint: int
        if (!is_null($version) && !is_numeric($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Get modified value
     * @return string|null
     */
    public function getModified()
    {
        return $this->modified;
    }
    /**
     * Set modified value
     * @param string $modified
     * @return \StructType\Item
     */
    public function setModified($modified = null)
    {
        // validation for constraint: string
        if (!is_null($modified) && !is_string($modified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modified)), __LINE__);
        }
        $this->modified = $modified;
        return $this;
    }
    /**
     * Get changes value
     * @return \StructType\ItemChanges|null
     */
    public function getChanges()
    {
        return $this->changes;
    }
    /**
     * Set changes value
     * @param \StructType\ItemChanges $changes
     * @return \StructType\Item
     */
    public function setChanges(\StructType\ItemChanges $changes = null)
    {
        $this->changes = $changes;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Item
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
