<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ImAddressList StructType
 * @subpackage Structs
 */
class ImAddressList extends AbstractStructBase
{
    /**
     * The im
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ImAddress[]
     */
    public $im;
    /**
     * Constructor method for ImAddressList
     * @uses ImAddressList::setIm()
     * @param \StructType\ImAddress[] $im
     */
    public function __construct(array $im = array())
    {
        $this
            ->setIm($im);
    }
    /**
     * Get im value
     * @return \StructType\ImAddress[]|null
     */
    public function getIm()
    {
        return $this->im;
    }
    /**
     * Set im value
     * @throws \InvalidArgumentException
     * @param \StructType\ImAddress[] $im
     * @return \StructType\ImAddressList
     */
    public function setIm(array $im = array())
    {
        foreach ($im as $imAddressListImItem) {
            // validation for constraint: itemType
            if (!$imAddressListImItem instanceof \StructType\ImAddress) {
                throw new \InvalidArgumentException(sprintf('The im property can only contain items of \StructType\ImAddress, "%s" given', is_object($imAddressListImItem) ? get_class($imAddressListImItem) : gettype($imAddressListImItem)), __LINE__);
            }
        }
        $this->im = $im;
        return $this;
    }
    /**
     * Add item to im value
     * @throws \InvalidArgumentException
     * @param \StructType\ImAddress $item
     * @return \StructType\ImAddressList
     */
    public function addToIm(\StructType\ImAddress $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ImAddress) {
            throw new \InvalidArgumentException(sprintf('The im property can only contain items of \StructType\ImAddress, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->im[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ImAddressList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
