<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GroupMemberList StructType
 * @subpackage Structs
 */
class GroupMemberList extends AbstractStructBase
{
    /**
     * The member
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\GroupMember[]
     */
    public $member;
    /**
     * Constructor method for GroupMemberList
     * @uses GroupMemberList::setMember()
     * @param \StructType\GroupMember[] $member
     */
    public function __construct(array $member = array())
    {
        $this
            ->setMember($member);
    }
    /**
     * Get member value
     * @return \StructType\GroupMember[]|null
     */
    public function getMember()
    {
        return $this->member;
    }
    /**
     * Set member value
     * @throws \InvalidArgumentException
     * @param \StructType\GroupMember[] $member
     * @return \StructType\GroupMemberList
     */
    public function setMember(array $member = array())
    {
        foreach ($member as $groupMemberListMemberItem) {
            // validation for constraint: itemType
            if (!$groupMemberListMemberItem instanceof \StructType\GroupMember) {
                throw new \InvalidArgumentException(sprintf('The member property can only contain items of \StructType\GroupMember, "%s" given', is_object($groupMemberListMemberItem) ? get_class($groupMemberListMemberItem) : gettype($groupMemberListMemberItem)), __LINE__);
            }
        }
        $this->member = $member;
        return $this;
    }
    /**
     * Add item to member value
     * @throws \InvalidArgumentException
     * @param \StructType\GroupMember $item
     * @return \StructType\GroupMemberList
     */
    public function addToMember(\StructType\GroupMember $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GroupMember) {
            throw new \InvalidArgumentException(sprintf('The member property can only contain items of \StructType\GroupMember, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->member[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GroupMemberList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
