<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GroupMember StructType
 * Meta informations extracted from the WSDL
 * - minOccurs: 0
 * - type: xs:string
 * @subpackage Structs
 */
class GroupMember extends AbstractStructBase
{
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0 | 0
     * - ref: tns:id
     * - documentation: The unique identifier is a application defined string to uniquely identify an item. The string can optionally consist of two parts. The first part identifies a unique existence of an item. The second part of the string optionally
     * specifies instance information. The first and second part of the ID are separated by an '@'. For this reason neither the first nor second part can contain an '@' symbol. To determine whether or not two items are the same item, the consumer of this
     * API should compare the first part of the ids of the two items (i.e. all of the id up to the @ symbol).
     * - pattern: [^@]+(@*)?
     * - type: xs:string
     * @var string
     */
    public $id;
    /**
     * The sid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:sid
     * @var int
     */
    public $sid;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:name
     * @var string
     */
    public $name;
    /**
     * The email
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:email
     * @var string
     */
    public $email;
    /**
     * The distType
     * Meta informations extracted from the WSDL
     * - default: TO
     * - minOccurs: 0
     * @var string
     */
    public $distType;
    /**
     * The itemType
     * Meta informations extracted from the WSDL
     * - default: Contact
     * - minOccurs: 0
     * @var string
     */
    public $itemType;
    /**
     * The members
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\GroupMemberList
     */
    public $members;
    /**
     * Constructor method for GroupMember
     * @uses GroupMember::setId()
     * @uses GroupMember::setSid()
     * @uses GroupMember::setName()
     * @uses GroupMember::setEmail()
     * @uses GroupMember::setDistType()
     * @uses GroupMember::setItemType()
     * @uses GroupMember::setMembers()
     * @param string $id
     * @param int $sid
     * @param string $name
     * @param string $email
     * @param string $distType
     * @param string $itemType
     * @param \StructType\GroupMemberList $members
     */
    public function __construct($id = null, $sid = null, $name = null, $email = null, $distType = 'TO', $itemType = 'Contact', \StructType\GroupMemberList $members = null)
    {
        $this
            ->setId($id)
            ->setSid($sid)
            ->setName($name)
            ->setEmail($email)
            ->setDistType($distType)
            ->setItemType($itemType)
            ->setMembers($members);
    }
    /**
     * Get id value
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\GroupMember
     */
    public function setId($id = null)
    {
        // validation for constraint: pattern
        if (is_scalar($id) && !preg_match('/[^@]+(@*)?/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[^@]+(@*)?", "%s" given', var_export($id, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get sid value
     * @return int|null
     */
    public function getSid()
    {
        return $this->sid;
    }
    /**
     * Set sid value
     * @param int $sid
     * @return \StructType\GroupMember
     */
    public function setSid($sid = null)
    {
        // validation for constraint: int
        if (!is_null($sid) && !is_numeric($sid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sid)), __LINE__);
        }
        $this->sid = $sid;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\GroupMember
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\GroupMember
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get distType value
     * @return string|null
     */
    public function getDistType()
    {
        return $this->distType;
    }
    /**
     * Set distType value
     * @uses \EnumType\DistributionType::valueIsValid()
     * @uses \EnumType\DistributionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $distType
     * @return \StructType\GroupMember
     */
    public function setDistType($distType = 'TO')
    {
        // validation for constraint: enumeration
        if (!\EnumType\DistributionType::valueIsValid($distType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $distType, implode(', ', \EnumType\DistributionType::getValidValues())), __LINE__);
        }
        $this->distType = $distType;
        return $this;
    }
    /**
     * Get itemType value
     * @return string|null
     */
    public function getItemType()
    {
        return $this->itemType;
    }
    /**
     * Set itemType value
     * @uses \EnumType\ContactType::valueIsValid()
     * @uses \EnumType\ContactType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $itemType
     * @return \StructType\GroupMember
     */
    public function setItemType($itemType = 'Contact')
    {
        // validation for constraint: enumeration
        if (!\EnumType\ContactType::valueIsValid($itemType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $itemType, implode(', ', \EnumType\ContactType::getValidValues())), __LINE__);
        }
        $this->itemType = $itemType;
        return $this;
    }
    /**
     * Get members value
     * @return \StructType\GroupMemberList|null
     */
    public function getMembers()
    {
        return $this->members;
    }
    /**
     * Set members value
     * @param \StructType\GroupMemberList $members
     * @return \StructType\GroupMember
     */
    public function setMembers(\StructType\GroupMemberList $members = null)
    {
        $this->members = $members;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GroupMember
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
