<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getUserListRequest StructType
 * @subpackage Structs
 */
class GetUserListRequest extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The key
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $key;
    /**
     * The noop
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $noop;
    /**
     * Constructor method for getUserListRequest
     * @uses GetUserListRequest::setName()
     * @uses GetUserListRequest::setKey()
     * @uses GetUserListRequest::setNoop()
     * @param string $name
     * @param string $key
     * @param bool $noop
     */
    public function __construct($name = null, $key = null, $noop = null)
    {
        $this
            ->setName($name)
            ->setKey($key)
            ->setNoop($noop);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\GetUserListRequest
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get key value
     * @return string|null
     */
    public function getKey()
    {
        return $this->key;
    }
    /**
     * Set key value
     * @param string $key
     * @return \StructType\GetUserListRequest
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($key)), __LINE__);
        }
        $this->key = $key;
        return $this;
    }
    /**
     * Get noop value
     * @return bool|null
     */
    public function getNoop()
    {
        return $this->noop;
    }
    /**
     * Set noop value
     * @param bool $noop
     * @return \StructType\GetUserListRequest
     */
    public function setNoop($noop = null)
    {
        // validation for constraint: boolean
        if (!is_null($noop) && !is_bool($noop)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($noop)), __LINE__);
        }
        $this->noop = $noop;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetUserListRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
