<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getQuickMessagesResponse StructType
 * @subpackage Structs
 */
class GetQuickMessagesResponse extends AbstractStructBase
{
    /**
     * The startDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: types:startDate
     * @var string
     */
    public $startDate;
    /**
     * The items
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Items
     */
    public $items;
    /**
     * The status
     * @var \StructType\Status
     */
    public $status;
    /**
     * Constructor method for getQuickMessagesResponse
     * @uses GetQuickMessagesResponse::setStartDate()
     * @uses GetQuickMessagesResponse::setItems()
     * @uses GetQuickMessagesResponse::setStatus()
     * @param string $startDate
     * @param \StructType\Items $items
     * @param \StructType\Status $status
     */
    public function __construct($startDate = null, \StructType\Items $items = null, \StructType\Status $status = null)
    {
        $this
            ->setStartDate($startDate)
            ->setItems($items)
            ->setStatus($status);
    }
    /**
     * Get startDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \StructType\GetQuickMessagesResponse
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get items value
     * @return \StructType\Items|null
     */
    public function getItems()
    {
        return $this->items;
    }
    /**
     * Set items value
     * @param \StructType\Items $items
     * @return \StructType\GetQuickMessagesResponse
     */
    public function setItems(\StructType\Items $items = null)
    {
        $this->items = $items;
        return $this;
    }
    /**
     * Get status value
     * @return \StructType\Status|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param \StructType\Status $status
     * @return \StructType\GetQuickMessagesResponse
     */
    public function setStatus(\StructType\Status $status = null)
    {
        $this->status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetQuickMessagesResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
