<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getMemberOfResponse StructType
 * @subpackage Structs
 */
class GetMemberOfResponse extends AbstractStructBase
{
    /**
     * The group
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Owner[]
     */
    public $group;
    /**
     * The status
     * @var \StructType\Status
     */
    public $status;
    /**
     * Constructor method for getMemberOfResponse
     * @uses GetMemberOfResponse::setGroup()
     * @uses GetMemberOfResponse::setStatus()
     * @param \StructType\Owner[] $group
     * @param \StructType\Status $status
     */
    public function __construct(array $group = array(), \StructType\Status $status = null)
    {
        $this
            ->setGroup($group)
            ->setStatus($status);
    }
    /**
     * Get group value
     * @return \StructType\Owner[]|null
     */
    public function getGroup()
    {
        return $this->group;
    }
    /**
     * Set group value
     * @throws \InvalidArgumentException
     * @param \StructType\Owner[] $group
     * @return \StructType\GetMemberOfResponse
     */
    public function setGroup(array $group = array())
    {
        foreach ($group as $getMemberOfResponseGroupItem) {
            // validation for constraint: itemType
            if (!$getMemberOfResponseGroupItem instanceof \StructType\Owner) {
                throw new \InvalidArgumentException(sprintf('The group property can only contain items of \StructType\Owner, "%s" given', is_object($getMemberOfResponseGroupItem) ? get_class($getMemberOfResponseGroupItem) : gettype($getMemberOfResponseGroupItem)), __LINE__);
            }
        }
        $this->group = $group;
        return $this;
    }
    /**
     * Add item to group value
     * @throws \InvalidArgumentException
     * @param \StructType\Owner $item
     * @return \StructType\GetMemberOfResponse
     */
    public function addToGroup(\StructType\Owner $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Owner) {
            throw new \InvalidArgumentException(sprintf('The group property can only contain items of \StructType\Owner, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->group[] = $item;
        return $this;
    }
    /**
     * Get status value
     * @return \StructType\Status|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param \StructType\Status $status
     * @return \StructType\GetMemberOfResponse
     */
    public function setStatus(\StructType\Status $status = null)
    {
        $this->status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetMemberOfResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
