<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getEventsRequest StructType
 * @subpackage Structs
 */
class GetEventsRequest extends AbstractStructBase
{
    /**
     * The key
     * Meta informations extracted from the WSDL
     * - ref: tns:key
     * @var string
     */
    public $key;
    /**
     * The from
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $from;
    /**
     * The until
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $until;
    /**
     * The uid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $uid;
    /**
     * The count
     * Meta informations extracted from the WSDL
     * - default: -1
     * @var int
     */
    public $count;
    /**
     * The remove
     * Meta informations extracted from the WSDL
     * - default: 0
     * @var bool
     */
    public $remove;
    /**
     * The notify
     * Meta informations extracted from the WSDL
     * - default: 0
     * @var bool
     */
    public $notify;
    /**
     * The view
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $view;
    /**
     * Constructor method for getEventsRequest
     * @uses GetEventsRequest::setKey()
     * @uses GetEventsRequest::setFrom()
     * @uses GetEventsRequest::setUntil()
     * @uses GetEventsRequest::setUid()
     * @uses GetEventsRequest::setCount()
     * @uses GetEventsRequest::setRemove()
     * @uses GetEventsRequest::setNotify()
     * @uses GetEventsRequest::setView()
     * @param string $key
     * @param string $from
     * @param string $until
     * @param int $uid
     * @param int $count
     * @param bool $remove
     * @param bool $notify
     * @param string $view
     */
    public function __construct($key = null, $from = null, $until = null, $uid = null, $count = -1, $remove = false, $notify = false, $view = null)
    {
        $this
            ->setKey($key)
            ->setFrom($from)
            ->setUntil($until)
            ->setUid($uid)
            ->setCount($count)
            ->setRemove($remove)
            ->setNotify($notify)
            ->setView($view);
    }
    /**
     * Get key value
     * @return string|null
     */
    public function getKey()
    {
        return $this->key;
    }
    /**
     * Set key value
     * @param string $key
     * @return \StructType\GetEventsRequest
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($key)), __LINE__);
        }
        $this->key = $key;
        return $this;
    }
    /**
     * Get from value
     * @return string|null
     */
    public function getFrom()
    {
        return $this->from;
    }
    /**
     * Set from value
     * @param string $from
     * @return \StructType\GetEventsRequest
     */
    public function setFrom($from = null)
    {
        // validation for constraint: string
        if (!is_null($from) && !is_string($from)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($from)), __LINE__);
        }
        $this->from = $from;
        return $this;
    }
    /**
     * Get until value
     * @return string|null
     */
    public function getUntil()
    {
        return $this->until;
    }
    /**
     * Set until value
     * @param string $until
     * @return \StructType\GetEventsRequest
     */
    public function setUntil($until = null)
    {
        // validation for constraint: string
        if (!is_null($until) && !is_string($until)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($until)), __LINE__);
        }
        $this->until = $until;
        return $this;
    }
    /**
     * Get uid value
     * @return int|null
     */
    public function getUid()
    {
        return $this->uid;
    }
    /**
     * Set uid value
     * @param int $uid
     * @return \StructType\GetEventsRequest
     */
    public function setUid($uid = null)
    {
        // validation for constraint: int
        if (!is_null($uid) && !is_numeric($uid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($uid)), __LINE__);
        }
        $this->uid = $uid;
        return $this;
    }
    /**
     * Get count value
     * @return int|null
     */
    public function getCount()
    {
        return $this->count;
    }
    /**
     * Set count value
     * @param int $count
     * @return \StructType\GetEventsRequest
     */
    public function setCount($count = -1)
    {
        // validation for constraint: int
        if (!is_null($count) && !is_numeric($count)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($count)), __LINE__);
        }
        $this->count = $count;
        return $this;
    }
    /**
     * Get remove value
     * @return bool|null
     */
    public function getRemove()
    {
        return $this->remove;
    }
    /**
     * Set remove value
     * @param bool $remove
     * @return \StructType\GetEventsRequest
     */
    public function setRemove($remove = false)
    {
        // validation for constraint: boolean
        if (!is_null($remove) && !is_bool($remove)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($remove)), __LINE__);
        }
        $this->remove = $remove;
        return $this;
    }
    /**
     * Get notify value
     * @return bool|null
     */
    public function getNotify()
    {
        return $this->notify;
    }
    /**
     * Set notify value
     * @param bool $notify
     * @return \StructType\GetEventsRequest
     */
    public function setNotify($notify = false)
    {
        // validation for constraint: boolean
        if (!is_null($notify) && !is_bool($notify)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($notify)), __LINE__);
        }
        $this->notify = $notify;
        return $this;
    }
    /**
     * Get view value
     * @return string|null
     */
    public function getView()
    {
        return $this->view;
    }
    /**
     * Set view value
     * @param string $view
     * @return \StructType\GetEventsRequest
     */
    public function setView($view = null)
    {
        // validation for constraint: string
        if (!is_null($view) && !is_string($view)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($view)), __LINE__);
        }
        $this->view = $view;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetEventsRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
