<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getDeltasRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: container: The only valid container at this time is the GroupWise System Address book uid. view: This is the view for the items that are returned.
 * @subpackage Structs
 */
class GetDeltasRequest extends AbstractStructBase
{
    /**
     * The container
     * Meta informations extracted from the WSDL
     * - documentation: The unique identifier is a application defined string to uniquely identify an item. The string can optionally consist of two parts. The first part identifies a unique existence of an item. The second part of the string optionally
     * specifies instance information. The first and second part of the ID are separated by an '@'. For this reason neither the first nor second part can contain an '@' symbol. To determine whether or not two items are the same item, the consumer of this
     * API should compare the first part of the ids of the two items (i.e. all of the id up to the @ symbol).
     * - minOccurs: 0
     * - pattern: [^@]+(@*)?
     * - type: xs:string
     * @var string
     */
    public $container;
    /**
     * The view
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $view;
    /**
     * The deltaInfo
     * @var \StructType\DeltaInfo
     */
    public $deltaInfo;
    /**
     * Constructor method for getDeltasRequest
     * @uses GetDeltasRequest::setContainer()
     * @uses GetDeltasRequest::setView()
     * @uses GetDeltasRequest::setDeltaInfo()
     * @param string $container
     * @param string $view
     * @param \StructType\DeltaInfo $deltaInfo
     */
    public function __construct($container = null, $view = null, \StructType\DeltaInfo $deltaInfo = null)
    {
        $this
            ->setContainer($container)
            ->setView($view)
            ->setDeltaInfo($deltaInfo);
    }
    /**
     * Get container value
     * @return string|null
     */
    public function getContainer()
    {
        return $this->container;
    }
    /**
     * Set container value
     * @param string $container
     * @return \StructType\GetDeltasRequest
     */
    public function setContainer($container = null)
    {
        // validation for constraint: pattern
        if (is_scalar($container) && !preg_match('/[^@]+(@*)?/', $container)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[^@]+(@*)?", "%s" given', var_export($container, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($container) && !is_string($container)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($container)), __LINE__);
        }
        $this->container = $container;
        return $this;
    }
    /**
     * Get view value
     * @return string|null
     */
    public function getView()
    {
        return $this->view;
    }
    /**
     * Set view value
     * @param string $view
     * @return \StructType\GetDeltasRequest
     */
    public function setView($view = null)
    {
        // validation for constraint: string
        if (!is_null($view) && !is_string($view)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($view)), __LINE__);
        }
        $this->view = $view;
        return $this;
    }
    /**
     * Get deltaInfo value
     * @return \StructType\DeltaInfo|null
     */
    public function getDeltaInfo()
    {
        return $this->deltaInfo;
    }
    /**
     * Set deltaInfo value
     * @param \StructType\DeltaInfo $deltaInfo
     * @return \StructType\GetDeltasRequest
     */
    public function setDeltaInfo(\StructType\DeltaInfo $deltaInfo = null)
    {
        $this->deltaInfo = $deltaInfo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetDeltasRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
