<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getCustomListRequest StructType
 * @subpackage Structs
 */
class GetCustomListRequest extends AbstractStructBase
{
    /**
     * The library
     * Meta informations extracted from the WSDL
     * - minOccurs: 0 | 0
     * - documentation: The unique identifier is a application defined string to uniquely identify an item. The string can optionally consist of two parts. The first part identifies a unique existence of an item. The second part of the string optionally
     * specifies instance information. The first and second part of the ID are separated by an '@'. For this reason neither the first nor second part can contain an '@' symbol. To determine whether or not two items are the same item, the consumer of this
     * API should compare the first part of the ids of the two items (i.e. all of the id up to the @ symbol).
     * - pattern: [^@]+(@*)?
     * - type: xs:string
     * @var string
     */
    public $library;
    /**
     * Constructor method for getCustomListRequest
     * @uses GetCustomListRequest::setLibrary()
     * @param string $library
     */
    public function __construct($library = null)
    {
        $this
            ->setLibrary($library);
    }
    /**
     * Get library value
     * @return string
     */
    public function getLibrary()
    {
        return $this->library;
    }
    /**
     * Set library value
     * @param string $library
     * @return \StructType\GetCustomListRequest
     */
    public function setLibrary($library = null)
    {
        // validation for constraint: pattern
        if (is_scalar($library) && !preg_match('/[^@]+(@*)?/', $library)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[^@]+(@*)?", "%s" given', var_export($library, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($library) && !is_string($library)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($library)), __LINE__);
        }
        $this->library = $library;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetCustomListRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
