<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getArchiveItemsRequest StructType
 * @subpackage Structs
 */
class GetArchiveItemsRequest extends AbstractStructBase
{
    /**
     * The container
     * Meta informations extracted from the WSDL
     * - minOccurs: 0 | 0
     * - documentation: The unique identifier is a application defined string to uniquely identify an item. The string can optionally consist of two parts. The first part identifies a unique existence of an item. The second part of the string optionally
     * specifies instance information. The first and second part of the ID are separated by an '@'. For this reason neither the first nor second part can contain an '@' symbol. To determine whether or not two items are the same item, the consumer of this
     * API should compare the first part of the ids of the two items (i.e. all of the id up to the @ symbol).
     * - pattern: [^@]+(@*)?
     * - type: xs:string
     * @var string
     */
    public $container;
    /**
     * The view
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $view;
    /**
     * The filter
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Filter
     */
    public $filter;
    /**
     * The items
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ItemRefList
     */
    public $items;
    /**
     * The count
     * Meta informations extracted from the WSDL
     * - default: -1
     * @var int
     */
    public $count;
    /**
     * The path
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $path;
    /**
     * Constructor method for getArchiveItemsRequest
     * @uses GetArchiveItemsRequest::setContainer()
     * @uses GetArchiveItemsRequest::setView()
     * @uses GetArchiveItemsRequest::setFilter()
     * @uses GetArchiveItemsRequest::setItems()
     * @uses GetArchiveItemsRequest::setCount()
     * @uses GetArchiveItemsRequest::setPath()
     * @param string $container
     * @param string $view
     * @param \StructType\Filter $filter
     * @param \StructType\ItemRefList $items
     * @param int $count
     * @param string $path
     */
    public function __construct($container = null, $view = null, \StructType\Filter $filter = null, \StructType\ItemRefList $items = null, $count = -1, $path = null)
    {
        $this
            ->setContainer($container)
            ->setView($view)
            ->setFilter($filter)
            ->setItems($items)
            ->setCount($count)
            ->setPath($path);
    }
    /**
     * Get container value
     * @return string
     */
    public function getContainer()
    {
        return $this->container;
    }
    /**
     * Set container value
     * @param string $container
     * @return \StructType\GetArchiveItemsRequest
     */
    public function setContainer($container = null)
    {
        // validation for constraint: pattern
        if (is_scalar($container) && !preg_match('/[^@]+(@*)?/', $container)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[^@]+(@*)?", "%s" given', var_export($container, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($container) && !is_string($container)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($container)), __LINE__);
        }
        $this->container = $container;
        return $this;
    }
    /**
     * Get view value
     * @return string|null
     */
    public function getView()
    {
        return $this->view;
    }
    /**
     * Set view value
     * @param string $view
     * @return \StructType\GetArchiveItemsRequest
     */
    public function setView($view = null)
    {
        // validation for constraint: string
        if (!is_null($view) && !is_string($view)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($view)), __LINE__);
        }
        $this->view = $view;
        return $this;
    }
    /**
     * Get filter value
     * @return \StructType\Filter|null
     */
    public function getFilter()
    {
        return $this->filter;
    }
    /**
     * Set filter value
     * @param \StructType\Filter $filter
     * @return \StructType\GetArchiveItemsRequest
     */
    public function setFilter(\StructType\Filter $filter = null)
    {
        $this->filter = $filter;
        return $this;
    }
    /**
     * Get items value
     * @return \StructType\ItemRefList|null
     */
    public function getItems()
    {
        return $this->items;
    }
    /**
     * Set items value
     * @param \StructType\ItemRefList $items
     * @return \StructType\GetArchiveItemsRequest
     */
    public function setItems(\StructType\ItemRefList $items = null)
    {
        $this->items = $items;
        return $this;
    }
    /**
     * Get count value
     * @return int|null
     */
    public function getCount()
    {
        return $this->count;
    }
    /**
     * Set count value
     * @param int $count
     * @return \StructType\GetArchiveItemsRequest
     */
    public function setCount($count = -1)
    {
        // validation for constraint: int
        if (!is_null($count) && !is_numeric($count)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($count)), __LINE__);
        }
        $this->count = $count;
        return $this;
    }
    /**
     * Get path value
     * @return string|null
     */
    public function getPath()
    {
        return $this->path;
    }
    /**
     * Set path value
     * @param string $path
     * @return \StructType\GetArchiveItemsRequest
     */
    public function setPath($path = null)
    {
        // validation for constraint: string
        if (!is_null($path) && !is_string($path)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($path)), __LINE__);
        }
        $this->path = $path;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetArchiveItemsRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
