<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FreeBusyUserList StructType
 * @subpackage Structs
 */
class FreeBusyUserList extends AbstractStructBase
{
    /**
     * The user
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NameAndEmail[]
     */
    public $user;
    /**
     * The external
     * @var bool
     */
    public $external;
    /**
     * The externalGroupWise
     * @var bool
     */
    public $externalGroupWise;
    /**
     * Constructor method for FreeBusyUserList
     * @uses FreeBusyUserList::setUser()
     * @uses FreeBusyUserList::setExternal()
     * @uses FreeBusyUserList::setExternalGroupWise()
     * @param \StructType\NameAndEmail[] $user
     * @param bool $external
     * @param bool $externalGroupWise
     */
    public function __construct(array $user = array(), $external = null, $externalGroupWise = null)
    {
        $this
            ->setUser($user)
            ->setExternal($external)
            ->setExternalGroupWise($externalGroupWise);
    }
    /**
     * Get user value
     * @return \StructType\NameAndEmail[]|null
     */
    public function getUser()
    {
        return $this->user;
    }
    /**
     * Set user value
     * @throws \InvalidArgumentException
     * @param \StructType\NameAndEmail[] $user
     * @return \StructType\FreeBusyUserList
     */
    public function setUser(array $user = array())
    {
        foreach ($user as $freeBusyUserListUserItem) {
            // validation for constraint: itemType
            if (!$freeBusyUserListUserItem instanceof \StructType\NameAndEmail) {
                throw new \InvalidArgumentException(sprintf('The user property can only contain items of \StructType\NameAndEmail, "%s" given', is_object($freeBusyUserListUserItem) ? get_class($freeBusyUserListUserItem) : gettype($freeBusyUserListUserItem)), __LINE__);
            }
        }
        $this->user = $user;
        return $this;
    }
    /**
     * Add item to user value
     * @throws \InvalidArgumentException
     * @param \StructType\NameAndEmail $item
     * @return \StructType\FreeBusyUserList
     */
    public function addToUser(\StructType\NameAndEmail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NameAndEmail) {
            throw new \InvalidArgumentException(sprintf('The user property can only contain items of \StructType\NameAndEmail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->user[] = $item;
        return $this;
    }
    /**
     * Get external value
     * @return bool|null
     */
    public function getExternal()
    {
        return $this->external;
    }
    /**
     * Set external value
     * @param bool $external
     * @return \StructType\FreeBusyUserList
     */
    public function setExternal($external = null)
    {
        // validation for constraint: boolean
        if (!is_null($external) && !is_bool($external)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($external)), __LINE__);
        }
        $this->external = $external;
        return $this;
    }
    /**
     * Get externalGroupWise value
     * @return bool|null
     */
    public function getExternalGroupWise()
    {
        return $this->externalGroupWise;
    }
    /**
     * Set externalGroupWise value
     * @param bool $externalGroupWise
     * @return \StructType\FreeBusyUserList
     */
    public function setExternalGroupWise($externalGroupWise = null)
    {
        // validation for constraint: boolean
        if (!is_null($externalGroupWise) && !is_bool($externalGroupWise)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($externalGroupWise)), __LINE__);
        }
        $this->externalGroupWise = $externalGroupWise;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FreeBusyUserList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
