<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FreeBusyInfoList StructType
 * @subpackage Structs
 */
class FreeBusyInfoList extends AbstractStructBase
{
    /**
     * The user
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FreeBusyInfo[]
     */
    public $user;
    /**
     * Constructor method for FreeBusyInfoList
     * @uses FreeBusyInfoList::setUser()
     * @param \StructType\FreeBusyInfo[] $user
     */
    public function __construct(array $user = array())
    {
        $this
            ->setUser($user);
    }
    /**
     * Get user value
     * @return \StructType\FreeBusyInfo[]|null
     */
    public function getUser()
    {
        return $this->user;
    }
    /**
     * Set user value
     * @throws \InvalidArgumentException
     * @param \StructType\FreeBusyInfo[] $user
     * @return \StructType\FreeBusyInfoList
     */
    public function setUser(array $user = array())
    {
        foreach ($user as $freeBusyInfoListUserItem) {
            // validation for constraint: itemType
            if (!$freeBusyInfoListUserItem instanceof \StructType\FreeBusyInfo) {
                throw new \InvalidArgumentException(sprintf('The user property can only contain items of \StructType\FreeBusyInfo, "%s" given', is_object($freeBusyInfoListUserItem) ? get_class($freeBusyInfoListUserItem) : gettype($freeBusyInfoListUserItem)), __LINE__);
            }
        }
        $this->user = $user;
        return $this;
    }
    /**
     * Add item to user value
     * @throws \InvalidArgumentException
     * @param \StructType\FreeBusyInfo $item
     * @return \StructType\FreeBusyInfoList
     */
    public function addToUser(\StructType\FreeBusyInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FreeBusyInfo) {
            throw new \InvalidArgumentException(sprintf('The user property can only contain items of \StructType\FreeBusyInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->user[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FreeBusyInfoList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
