<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FreeBusyInfo StructType
 * @subpackage Structs
 */
class FreeBusyInfo extends NameAndEmail
{
    /**
     * The recipType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $recipType;
    /**
     * The blocks
     * @var \StructType\FreeBusyBlockList
     */
    public $blocks;
    /**
     * Constructor method for FreeBusyInfo
     * @uses FreeBusyInfo::setRecipType()
     * @uses FreeBusyInfo::setBlocks()
     * @param string $recipType
     * @param \StructType\FreeBusyBlockList $blocks
     */
    public function __construct($recipType = null, \StructType\FreeBusyBlockList $blocks = null)
    {
        $this
            ->setRecipType($recipType)
            ->setBlocks($blocks);
    }
    /**
     * Get recipType value
     * @return string|null
     */
    public function getRecipType()
    {
        return $this->recipType;
    }
    /**
     * Set recipType value
     * @uses \EnumType\RecipientType::valueIsValid()
     * @uses \EnumType\RecipientType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $recipType
     * @return \StructType\FreeBusyInfo
     */
    public function setRecipType($recipType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RecipientType::valueIsValid($recipType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $recipType, implode(', ', \EnumType\RecipientType::getValidValues())), __LINE__);
        }
        $this->recipType = $recipType;
        return $this;
    }
    /**
     * Get blocks value
     * @return \StructType\FreeBusyBlockList|null
     */
    public function getBlocks()
    {
        return $this->blocks;
    }
    /**
     * Set blocks value
     * @param \StructType\FreeBusyBlockList $blocks
     * @return \StructType\FreeBusyInfo
     */
    public function setBlocks(\StructType\FreeBusyBlockList $blocks = null)
    {
        $this->blocks = $blocks;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FreeBusyInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
