<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FolderList StructType
 * @subpackage Structs
 */
class FolderList extends AbstractStructBase
{
    /**
     * The folder
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Folder[]
     */
    public $folder;
    /**
     * Constructor method for FolderList
     * @uses FolderList::setFolder()
     * @param \StructType\Folder[] $folder
     */
    public function __construct(array $folder = array())
    {
        $this
            ->setFolder($folder);
    }
    /**
     * Get folder value
     * @return \StructType\Folder[]|null
     */
    public function getFolder()
    {
        return $this->folder;
    }
    /**
     * Set folder value
     * @throws \InvalidArgumentException
     * @param \StructType\Folder[] $folder
     * @return \StructType\FolderList
     */
    public function setFolder(array $folder = array())
    {
        foreach ($folder as $folderListFolderItem) {
            // validation for constraint: itemType
            if (!$folderListFolderItem instanceof \StructType\Folder) {
                throw new \InvalidArgumentException(sprintf('The folder property can only contain items of \StructType\Folder, "%s" given', is_object($folderListFolderItem) ? get_class($folderListFolderItem) : gettype($folderListFolderItem)), __LINE__);
            }
        }
        $this->folder = $folder;
        return $this;
    }
    /**
     * Add item to folder value
     * @throws \InvalidArgumentException
     * @param \StructType\Folder $item
     * @return \StructType\FolderList
     */
    public function addToFolder(\StructType\Folder $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Folder) {
            throw new \InvalidArgumentException(sprintf('The folder property can only contain items of \StructType\Folder, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->folder[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FolderList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
