<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FolderDisplaySettings StructType
 * @subpackage Structs
 */
class FolderDisplaySettings extends DisplaySettings
{
    /**
     * The panelColumns
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $panelColumns;
    /**
     * The panels
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PanelList
     */
    public $panels;
    /**
     * Constructor method for FolderDisplaySettings
     * @uses FolderDisplaySettings::setPanelColumns()
     * @uses FolderDisplaySettings::setPanels()
     * @param int $panelColumns
     * @param \StructType\PanelList $panels
     */
    public function __construct($panelColumns = null, \StructType\PanelList $panels = null)
    {
        $this
            ->setPanelColumns($panelColumns)
            ->setPanels($panels);
    }
    /**
     * Get panelColumns value
     * @return int|null
     */
    public function getPanelColumns()
    {
        return $this->panelColumns;
    }
    /**
     * Set panelColumns value
     * @param int $panelColumns
     * @return \StructType\FolderDisplaySettings
     */
    public function setPanelColumns($panelColumns = null)
    {
        // validation for constraint: int
        if (!is_null($panelColumns) && !is_numeric($panelColumns)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($panelColumns)), __LINE__);
        }
        $this->panelColumns = $panelColumns;
        return $this;
    }
    /**
     * Get panels value
     * @return \StructType\PanelList|null
     */
    public function getPanels()
    {
        return $this->panels;
    }
    /**
     * Set panels value
     * @param \StructType\PanelList $panels
     * @return \StructType\FolderDisplaySettings
     */
    public function setPanels(\StructType\PanelList $panels = null)
    {
        $this->panels = $panels;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FolderDisplaySettings
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
