<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FilterEntry StructType
 * @subpackage Structs
 */
class FilterEntry extends FilterElement
{
    /**
     * The field
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $field;
    /**
     * The custom
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Custom
     */
    public $custom;
    /**
     * The value
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $value;
    /**
     * The date
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $date;
    /**
     * The mask
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $mask;
    /**
     * Constructor method for FilterEntry
     * @uses FilterEntry::setField()
     * @uses FilterEntry::setCustom()
     * @uses FilterEntry::setValue()
     * @uses FilterEntry::setDate()
     * @uses FilterEntry::setMask()
     * @param string $field
     * @param \StructType\Custom $custom
     * @param string $value
     * @param string $date
     * @param string $mask
     */
    public function __construct($field = null, \StructType\Custom $custom = null, $value = null, $date = null, $mask = null)
    {
        $this
            ->setField($field)
            ->setCustom($custom)
            ->setValue($value)
            ->setDate($date)
            ->setMask($mask);
    }
    /**
     * Get field value
     * @return string|null
     */
    public function getField()
    {
        return $this->field;
    }
    /**
     * Set field value
     * @param string $field
     * @return \StructType\FilterEntry
     */
    public function setField($field = null)
    {
        // validation for constraint: string
        if (!is_null($field) && !is_string($field)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($field)), __LINE__);
        }
        $this->field = $field;
        return $this;
    }
    /**
     * Get custom value
     * @return \StructType\Custom|null
     */
    public function getCustom()
    {
        return $this->custom;
    }
    /**
     * Set custom value
     * @param \StructType\Custom $custom
     * @return \StructType\FilterEntry
     */
    public function setCustom(\StructType\Custom $custom = null)
    {
        $this->custom = $custom;
        return $this;
    }
    /**
     * Get value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param string $value
     * @return \StructType\FilterEntry
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Get date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @uses \EnumType\FilterDate::valueIsValid()
     * @uses \EnumType\FilterDate::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $date
     * @return \StructType\FilterEntry
     */
    public function setDate($date = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FilterDate::valueIsValid($date)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $date, implode(', ', \EnumType\FilterDate::getValidValues())), __LINE__);
        }
        $this->date = $date;
        return $this;
    }
    /**
     * Get mask value
     * @return string|null
     */
    public function getMask()
    {
        return $this->mask;
    }
    /**
     * Set mask value
     * @param string $mask
     * @return \StructType\FilterEntry
     */
    public function setMask($mask = null)
    {
        // validation for constraint: string
        if (!is_null($mask) && !is_string($mask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mask)), __LINE__);
        }
        $this->mask = $mask;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FilterEntry
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
