<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Events StructType
 * Meta informations extracted from the WSDL
 * - default: 0
 * - type: xs:boolean
 * @subpackage Structs
 */
class Events extends AbstractStructBase
{
    /**
     * The key
     * Meta informations extracted from the WSDL
     * - ref: tns:key
     * @var string
     */
    public $key;
    /**
     * The persistence
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $persistence;
    /**
     * The ipAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ipAddress;
    /**
     * The port
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $port;
    /**
     * The http
     * Meta informations extracted from the WSDL
     * - default: 0
     * - minOccurs: 0
     * @var bool
     */
    public $http;
    /**
     * The ignoreAfter
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ignoreAfter;
    /**
     * The definition
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EventDefinition
     */
    public $definition;
    /**
     * The enabled
     * Meta informations extracted from the WSDL
     * - default: 0
     * @var bool
     */
    public $enabled;
    /**
     * Constructor method for Events
     * @uses Events::setKey()
     * @uses Events::setPersistence()
     * @uses Events::setIpAddress()
     * @uses Events::setPort()
     * @uses Events::setHttp()
     * @uses Events::setIgnoreAfter()
     * @uses Events::setDefinition()
     * @uses Events::setEnabled()
     * @param string $key
     * @param string $persistence
     * @param string $ipAddress
     * @param int $port
     * @param bool $http
     * @param string $ignoreAfter
     * @param \StructType\EventDefinition $definition
     * @param bool $enabled
     */
    public function __construct($key = null, $persistence = null, $ipAddress = null, $port = null, $http = false, $ignoreAfter = null, \StructType\EventDefinition $definition = null, $enabled = false)
    {
        $this
            ->setKey($key)
            ->setPersistence($persistence)
            ->setIpAddress($ipAddress)
            ->setPort($port)
            ->setHttp($http)
            ->setIgnoreAfter($ignoreAfter)
            ->setDefinition($definition)
            ->setEnabled($enabled);
    }
    /**
     * Get key value
     * @return string|null
     */
    public function getKey()
    {
        return $this->key;
    }
    /**
     * Set key value
     * @param string $key
     * @return \StructType\Events
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($key)), __LINE__);
        }
        $this->key = $key;
        return $this;
    }
    /**
     * Get persistence value
     * @return string|null
     */
    public function getPersistence()
    {
        return $this->persistence;
    }
    /**
     * Set persistence value
     * @param string $persistence
     * @return \StructType\Events
     */
    public function setPersistence($persistence = null)
    {
        // validation for constraint: string
        if (!is_null($persistence) && !is_string($persistence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($persistence)), __LINE__);
        }
        $this->persistence = $persistence;
        return $this;
    }
    /**
     * Get ipAddress value
     * @return string|null
     */
    public function getIpAddress()
    {
        return $this->ipAddress;
    }
    /**
     * Set ipAddress value
     * @param string $ipAddress
     * @return \StructType\Events
     */
    public function setIpAddress($ipAddress = null)
    {
        // validation for constraint: string
        if (!is_null($ipAddress) && !is_string($ipAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ipAddress)), __LINE__);
        }
        $this->ipAddress = $ipAddress;
        return $this;
    }
    /**
     * Get port value
     * @return int|null
     */
    public function getPort()
    {
        return $this->port;
    }
    /**
     * Set port value
     * @param int $port
     * @return \StructType\Events
     */
    public function setPort($port = null)
    {
        // validation for constraint: int
        if (!is_null($port) && !is_numeric($port)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($port)), __LINE__);
        }
        $this->port = $port;
        return $this;
    }
    /**
     * Get http value
     * @return bool|null
     */
    public function getHttp()
    {
        return $this->http;
    }
    /**
     * Set http value
     * @param bool $http
     * @return \StructType\Events
     */
    public function setHttp($http = false)
    {
        // validation for constraint: boolean
        if (!is_null($http) && !is_bool($http)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($http)), __LINE__);
        }
        $this->http = $http;
        return $this;
    }
    /**
     * Get ignoreAfter value
     * @return string|null
     */
    public function getIgnoreAfter()
    {
        return $this->ignoreAfter;
    }
    /**
     * Set ignoreAfter value
     * @param string $ignoreAfter
     * @return \StructType\Events
     */
    public function setIgnoreAfter($ignoreAfter = null)
    {
        // validation for constraint: string
        if (!is_null($ignoreAfter) && !is_string($ignoreAfter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ignoreAfter)), __LINE__);
        }
        $this->ignoreAfter = $ignoreAfter;
        return $this;
    }
    /**
     * Get definition value
     * @return \StructType\EventDefinition|null
     */
    public function getDefinition()
    {
        return $this->definition;
    }
    /**
     * Set definition value
     * @param \StructType\EventDefinition $definition
     * @return \StructType\Events
     */
    public function setDefinition(\StructType\EventDefinition $definition = null)
    {
        $this->definition = $definition;
        return $this;
    }
    /**
     * Get enabled value
     * @return bool|null
     */
    public function getEnabled()
    {
        return $this->enabled;
    }
    /**
     * Set enabled value
     * @param bool $enabled
     * @return \StructType\Events
     */
    public function setEnabled($enabled = false)
    {
        // validation for constraint: boolean
        if (!is_null($enabled) && !is_bool($enabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($enabled)), __LINE__);
        }
        $this->enabled = $enabled;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Events
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
