<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EventList StructType
 * @subpackage Structs
 */
class EventList extends AbstractStructBase
{
    /**
     * The event
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Event[]
     */
    public $event;
    /**
     * Constructor method for EventList
     * @uses EventList::setEvent()
     * @param \StructType\Event[] $event
     */
    public function __construct(array $event = array())
    {
        $this
            ->setEvent($event);
    }
    /**
     * Get event value
     * @return \StructType\Event[]|null
     */
    public function getEvent()
    {
        return $this->event;
    }
    /**
     * Set event value
     * @throws \InvalidArgumentException
     * @param \StructType\Event[] $event
     * @return \StructType\EventList
     */
    public function setEvent(array $event = array())
    {
        foreach ($event as $eventListEventItem) {
            // validation for constraint: itemType
            if (!$eventListEventItem instanceof \StructType\Event) {
                throw new \InvalidArgumentException(sprintf('The event property can only contain items of \StructType\Event, "%s" given', is_object($eventListEventItem) ? get_class($eventListEventItem) : gettype($eventListEventItem)), __LINE__);
            }
        }
        $this->event = $event;
        return $this;
    }
    /**
     * Add item to event value
     * @throws \InvalidArgumentException
     * @param \StructType\Event $item
     * @return \StructType\EventList
     */
    public function addToEvent(\StructType\Event $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Event) {
            throw new \InvalidArgumentException(sprintf('The event property can only contain items of \StructType\Event, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->event[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EventList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
