<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EventDefinition StructType
 * @subpackage Structs
 */
class EventDefinition extends AbstractStructBase
{
    /**
     * The events
     * @var \StructType\EventTypeList
     */
    public $events;
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $type;
    /**
     * The field
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:field
     * @var string
     */
    public $field;
    /**
     * The containers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ContainerList
     */
    public $containers;
    /**
     * The subType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $subType;
    /**
     * Constructor method for EventDefinition
     * @uses EventDefinition::setEvents()
     * @uses EventDefinition::setType()
     * @uses EventDefinition::setField()
     * @uses EventDefinition::setContainers()
     * @uses EventDefinition::setSubType()
     * @param \StructType\EventTypeList $events
     * @param string $type
     * @param string $field
     * @param \StructType\ContainerList $containers
     * @param string $subType
     */
    public function __construct(\StructType\EventTypeList $events = null, $type = null, $field = null, \StructType\ContainerList $containers = null, $subType = null)
    {
        $this
            ->setEvents($events)
            ->setType($type)
            ->setField($field)
            ->setContainers($containers)
            ->setSubType($subType);
    }
    /**
     * Get events value
     * @return \StructType\EventTypeList|null
     */
    public function getEvents()
    {
        return $this->events;
    }
    /**
     * Set events value
     * @param \StructType\EventTypeList $events
     * @return \StructType\EventDefinition
     */
    public function setEvents(\StructType\EventTypeList $events = null)
    {
        $this->events = $events;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\EventDefinition
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get field value
     * @return string|null
     */
    public function getField()
    {
        return $this->field;
    }
    /**
     * Set field value
     * @param string $field
     * @return \StructType\EventDefinition
     */
    public function setField($field = null)
    {
        // validation for constraint: string
        if (!is_null($field) && !is_string($field)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($field)), __LINE__);
        }
        $this->field = $field;
        return $this;
    }
    /**
     * Get containers value
     * @return \StructType\ContainerList|null
     */
    public function getContainers()
    {
        return $this->containers;
    }
    /**
     * Set containers value
     * @param \StructType\ContainerList $containers
     * @return \StructType\EventDefinition
     */
    public function setContainers(\StructType\ContainerList $containers = null)
    {
        $this->containers = $containers;
        return $this;
    }
    /**
     * Get subType value
     * @return string|null
     */
    public function getSubType()
    {
        return $this->subType;
    }
    /**
     * Set subType value
     * @param string $subType
     * @return \StructType\EventDefinition
     */
    public function setSubType($subType = null)
    {
        // validation for constraint: string
        if (!is_null($subType) && !is_string($subType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subType)), __LINE__);
        }
        $this->subType = $subType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EventDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
