<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Event StructType
 * Meta informations extracted from the WSDL
 * - minOccurs: 0
 * - type: xs:unsignedInt
 * @subpackage Structs
 */
class Event extends AbstractStructBase
{
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0 | 0
     * - documentation: The unique identifier is a application defined string to uniquely identify an item. The string can optionally consist of two parts. The first part identifies a unique existence of an item. The second part of the string optionally
     * specifies instance information. The first and second part of the ID are separated by an '@'. For this reason neither the first nor second part can contain an '@' symbol. To determine whether or not two items are the same item, the consumer of this
     * API should compare the first part of the ids of the two items (i.e. all of the id up to the @ symbol).
     * - pattern: [^@]+(@*)?
     * - type: xs:string
     * @var string
     */
    public $id;
    /**
     * The container
     * Meta informations extracted from the WSDL
     * - minOccurs: 0 | 0
     * - documentation: The unique identifier is a application defined string to uniquely identify an item. The string can optionally consist of two parts. The first part identifies a unique existence of an item. The second part of the string optionally
     * specifies instance information. The first and second part of the ID are separated by an '@'. For this reason neither the first nor second part can contain an '@' symbol. To determine whether or not two items are the same item, the consumer of this
     * API should compare the first part of the ids of the two items (i.e. all of the id up to the @ symbol).
     * - pattern: [^@]+(@*)?
     * - type: xs:string
     * @var string
     */
    public $container;
    /**
     * The from
     * Meta informations extracted from the WSDL
     * - minOccurs: 0 | 0
     * - documentation: The unique identifier is a application defined string to uniquely identify an item. The string can optionally consist of two parts. The first part identifies a unique existence of an item. The second part of the string optionally
     * specifies instance information. The first and second part of the ID are separated by an '@'. For this reason neither the first nor second part can contain an '@' symbol. To determine whether or not two items are the same item, the consumer of this
     * API should compare the first part of the ids of the two items (i.e. all of the id up to the @ symbol).
     * - pattern: [^@]+(@*)?
     * - type: xs:string
     * @var string
     */
    public $from;
    /**
     * The event
     * Meta informations extracted from the WSDL
     * - ref: tns:event
     * @var string
     */
    public $event;
    /**
     * The sid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $sid;
    /**
     * The timeStamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $timeStamp;
    /**
     * The field
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:field
     * @var string
     */
    public $field;
    /**
     * The key
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $key;
    /**
     * The uid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $uid;
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $type;
    /**
     * Constructor method for Event
     * @uses Event::setId()
     * @uses Event::setContainer()
     * @uses Event::setFrom()
     * @uses Event::setEvent()
     * @uses Event::setSid()
     * @uses Event::setTimeStamp()
     * @uses Event::setField()
     * @uses Event::setKey()
     * @uses Event::setUid()
     * @uses Event::setType()
     * @param string $id
     * @param string $container
     * @param string $from
     * @param string $event
     * @param int $sid
     * @param string $timeStamp
     * @param string $field
     * @param string $key
     * @param int $uid
     * @param string $type
     */
    public function __construct($id = null, $container = null, $from = null, $event = null, $sid = null, $timeStamp = null, $field = null, $key = null, $uid = null, $type = null)
    {
        $this
            ->setId($id)
            ->setContainer($container)
            ->setFrom($from)
            ->setEvent($event)
            ->setSid($sid)
            ->setTimeStamp($timeStamp)
            ->setField($field)
            ->setKey($key)
            ->setUid($uid)
            ->setType($type);
    }
    /**
     * Get id value
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\Event
     */
    public function setId($id = null)
    {
        // validation for constraint: pattern
        if (is_scalar($id) && !preg_match('/[^@]+(@*)?/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[^@]+(@*)?", "%s" given', var_export($id, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get container value
     * @return string
     */
    public function getContainer()
    {
        return $this->container;
    }
    /**
     * Set container value
     * @param string $container
     * @return \StructType\Event
     */
    public function setContainer($container = null)
    {
        // validation for constraint: pattern
        if (is_scalar($container) && !preg_match('/[^@]+(@*)?/', $container)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[^@]+(@*)?", "%s" given', var_export($container, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($container) && !is_string($container)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($container)), __LINE__);
        }
        $this->container = $container;
        return $this;
    }
    /**
     * Get from value
     * @return string
     */
    public function getFrom()
    {
        return $this->from;
    }
    /**
     * Set from value
     * @param string $from
     * @return \StructType\Event
     */
    public function setFrom($from = null)
    {
        // validation for constraint: pattern
        if (is_scalar($from) && !preg_match('/[^@]+(@*)?/', $from)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[^@]+(@*)?", "%s" given', var_export($from, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($from) && !is_string($from)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($from)), __LINE__);
        }
        $this->from = $from;
        return $this;
    }
    /**
     * Get event value
     * @return string|null
     */
    public function getEvent()
    {
        return $this->event;
    }
    /**
     * Set event value
     * @uses \EnumType\EventType::valueIsValid()
     * @uses \EnumType\EventType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $event
     * @return \StructType\Event
     */
    public function setEvent($event = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EventType::valueIsValid($event)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $event, implode(', ', \EnumType\EventType::getValidValues())), __LINE__);
        }
        $this->event = $event;
        return $this;
    }
    /**
     * Get sid value
     * @return int|null
     */
    public function getSid()
    {
        return $this->sid;
    }
    /**
     * Set sid value
     * @param int $sid
     * @return \StructType\Event
     */
    public function setSid($sid = null)
    {
        // validation for constraint: int
        if (!is_null($sid) && !is_numeric($sid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sid)), __LINE__);
        }
        $this->sid = $sid;
        return $this;
    }
    /**
     * Get timeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->timeStamp;
    }
    /**
     * Set timeStamp value
     * @param string $timeStamp
     * @return \StructType\Event
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timeStamp)), __LINE__);
        }
        $this->timeStamp = $timeStamp;
        return $this;
    }
    /**
     * Get field value
     * @return string|null
     */
    public function getField()
    {
        return $this->field;
    }
    /**
     * Set field value
     * @param string $field
     * @return \StructType\Event
     */
    public function setField($field = null)
    {
        // validation for constraint: string
        if (!is_null($field) && !is_string($field)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($field)), __LINE__);
        }
        $this->field = $field;
        return $this;
    }
    /**
     * Get key value
     * @return string|null
     */
    public function getKey()
    {
        return $this->key;
    }
    /**
     * Set key value
     * @param string $key
     * @return \StructType\Event
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($key)), __LINE__);
        }
        $this->key = $key;
        return $this;
    }
    /**
     * Get uid value
     * @return int|null
     */
    public function getUid()
    {
        return $this->uid;
    }
    /**
     * Set uid value
     * @param int $uid
     * @return \StructType\Event
     */
    public function setUid($uid = null)
    {
        // validation for constraint: int
        if (!is_null($uid) && !is_numeric($uid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($uid)), __LINE__);
        }
        $this->uid = $uid;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\ItemType::valueIsValid()
     * @uses \EnumType\ItemType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\Event
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ItemType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\ItemType::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Event
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
