<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentType StructType
 * @subpackage Structs
 */
class DocumentType extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - ref: tns:name
     * @var string
     */
    public $name;
    /**
     * The life
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $life;
    /**
     * The maximumVersions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $maximumVersions;
    /**
     * The ageAction
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ageAction;
    /**
     * Constructor method for DocumentType
     * @uses DocumentType::setName()
     * @uses DocumentType::setLife()
     * @uses DocumentType::setMaximumVersions()
     * @uses DocumentType::setAgeAction()
     * @param string $name
     * @param int $life
     * @param int $maximumVersions
     * @param string $ageAction
     */
    public function __construct($name = null, $life = null, $maximumVersions = null, $ageAction = null)
    {
        $this
            ->setName($name)
            ->setLife($life)
            ->setMaximumVersions($maximumVersions)
            ->setAgeAction($ageAction);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\DocumentType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get life value
     * @return int|null
     */
    public function getLife()
    {
        return $this->life;
    }
    /**
     * Set life value
     * @param int $life
     * @return \StructType\DocumentType
     */
    public function setLife($life = null)
    {
        // validation for constraint: int
        if (!is_null($life) && !is_numeric($life)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($life)), __LINE__);
        }
        $this->life = $life;
        return $this;
    }
    /**
     * Get maximumVersions value
     * @return int|null
     */
    public function getMaximumVersions()
    {
        return $this->maximumVersions;
    }
    /**
     * Set maximumVersions value
     * @param int $maximumVersions
     * @return \StructType\DocumentType
     */
    public function setMaximumVersions($maximumVersions = null)
    {
        // validation for constraint: int
        if (!is_null($maximumVersions) && !is_numeric($maximumVersions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maximumVersions)), __LINE__);
        }
        $this->maximumVersions = $maximumVersions;
        return $this;
    }
    /**
     * Get ageAction value
     * @return string|null
     */
    public function getAgeAction()
    {
        return $this->ageAction;
    }
    /**
     * Set ageAction value
     * @uses \EnumType\AgeAction::valueIsValid()
     * @uses \EnumType\AgeAction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ageAction
     * @return \StructType\DocumentType
     */
    public function setAgeAction($ageAction = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AgeAction::valueIsValid($ageAction)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $ageAction, implode(', ', \EnumType\AgeAction::getValidValues())), __LINE__);
        }
        $this->ageAction = $ageAction;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DocumentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
