<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentRef StructType
 * Meta informations extracted from the WSDL
 * - minOccurs: 0
 * - type: xs:string
 * @subpackage Structs
 */
class DocumentRef extends Mail
{
    /**
     * The library
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\NameAndEmail
     */
    public $library;
    /**
     * The documentNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $documentNumber;
    /**
     * The filename
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $filename;
    /**
     * The documentTypeName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $documentTypeName;
    /**
     * The author
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\NameAndEmail
     */
    public $author;
    /**
     * The creator
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\NameAndEmail
     */
    public $creator;
    /**
     * The versionCreator
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\NameAndEmail
     */
    public $versionCreator;
    /**
     * The officialVersion
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $officialVersion;
    /**
     * The currentVersion
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $currentVersion;
    /**
     * The versionNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $versionNumber;
    /**
     * The versionDescription
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $versionDescription;
    /**
     * The fileSize
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $fileSize;
    /**
     * The acl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AccessControlList
     */
    public $acl;
    /**
     * Constructor method for DocumentRef
     * @uses DocumentRef::setLibrary()
     * @uses DocumentRef::setDocumentNumber()
     * @uses DocumentRef::setFilename()
     * @uses DocumentRef::setDocumentTypeName()
     * @uses DocumentRef::setAuthor()
     * @uses DocumentRef::setCreator()
     * @uses DocumentRef::setVersionCreator()
     * @uses DocumentRef::setOfficialVersion()
     * @uses DocumentRef::setCurrentVersion()
     * @uses DocumentRef::setVersionNumber()
     * @uses DocumentRef::setVersionDescription()
     * @uses DocumentRef::setFileSize()
     * @uses DocumentRef::setAcl()
     * @param \StructType\NameAndEmail $library
     * @param int $documentNumber
     * @param string $filename
     * @param string $documentTypeName
     * @param \StructType\NameAndEmail $author
     * @param \StructType\NameAndEmail $creator
     * @param \StructType\NameAndEmail $versionCreator
     * @param int $officialVersion
     * @param int $currentVersion
     * @param int $versionNumber
     * @param string $versionDescription
     * @param int $fileSize
     * @param \StructType\AccessControlList $acl
     */
    public function __construct(\StructType\NameAndEmail $library = null, $documentNumber = null, $filename = null, $documentTypeName = null, \StructType\NameAndEmail $author = null, \StructType\NameAndEmail $creator = null, \StructType\NameAndEmail $versionCreator = null, $officialVersion = null, $currentVersion = null, $versionNumber = null, $versionDescription = null, $fileSize = null, \StructType\AccessControlList $acl = null)
    {
        $this
            ->setLibrary($library)
            ->setDocumentNumber($documentNumber)
            ->setFilename($filename)
            ->setDocumentTypeName($documentTypeName)
            ->setAuthor($author)
            ->setCreator($creator)
            ->setVersionCreator($versionCreator)
            ->setOfficialVersion($officialVersion)
            ->setCurrentVersion($currentVersion)
            ->setVersionNumber($versionNumber)
            ->setVersionDescription($versionDescription)
            ->setFileSize($fileSize)
            ->setAcl($acl);
    }
    /**
     * Get library value
     * @return \StructType\NameAndEmail|null
     */
    public function getLibrary()
    {
        return $this->library;
    }
    /**
     * Set library value
     * @param \StructType\NameAndEmail $library
     * @return \StructType\DocumentRef
     */
    public function setLibrary(\StructType\NameAndEmail $library = null)
    {
        $this->library = $library;
        return $this;
    }
    /**
     * Get documentNumber value
     * @return int|null
     */
    public function getDocumentNumber()
    {
        return $this->documentNumber;
    }
    /**
     * Set documentNumber value
     * @param int $documentNumber
     * @return \StructType\DocumentRef
     */
    public function setDocumentNumber($documentNumber = null)
    {
        // validation for constraint: int
        if (!is_null($documentNumber) && !is_numeric($documentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($documentNumber)), __LINE__);
        }
        $this->documentNumber = $documentNumber;
        return $this;
    }
    /**
     * Get filename value
     * @return string|null
     */
    public function getFilename()
    {
        return $this->filename;
    }
    /**
     * Set filename value
     * @param string $filename
     * @return \StructType\DocumentRef
     */
    public function setFilename($filename = null)
    {
        // validation for constraint: string
        if (!is_null($filename) && !is_string($filename)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($filename)), __LINE__);
        }
        $this->filename = $filename;
        return $this;
    }
    /**
     * Get documentTypeName value
     * @return string|null
     */
    public function getDocumentTypeName()
    {
        return $this->documentTypeName;
    }
    /**
     * Set documentTypeName value
     * @param string $documentTypeName
     * @return \StructType\DocumentRef
     */
    public function setDocumentTypeName($documentTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($documentTypeName) && !is_string($documentTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($documentTypeName)), __LINE__);
        }
        $this->documentTypeName = $documentTypeName;
        return $this;
    }
    /**
     * Get author value
     * @return \StructType\NameAndEmail|null
     */
    public function getAuthor()
    {
        return $this->author;
    }
    /**
     * Set author value
     * @param \StructType\NameAndEmail $author
     * @return \StructType\DocumentRef
     */
    public function setAuthor(\StructType\NameAndEmail $author = null)
    {
        $this->author = $author;
        return $this;
    }
    /**
     * Get creator value
     * @return \StructType\NameAndEmail|null
     */
    public function getCreator()
    {
        return $this->creator;
    }
    /**
     * Set creator value
     * @param \StructType\NameAndEmail $creator
     * @return \StructType\DocumentRef
     */
    public function setCreator(\StructType\NameAndEmail $creator = null)
    {
        $this->creator = $creator;
        return $this;
    }
    /**
     * Get versionCreator value
     * @return \StructType\NameAndEmail|null
     */
    public function getVersionCreator()
    {
        return $this->versionCreator;
    }
    /**
     * Set versionCreator value
     * @param \StructType\NameAndEmail $versionCreator
     * @return \StructType\DocumentRef
     */
    public function setVersionCreator(\StructType\NameAndEmail $versionCreator = null)
    {
        $this->versionCreator = $versionCreator;
        return $this;
    }
    /**
     * Get officialVersion value
     * @return int|null
     */
    public function getOfficialVersion()
    {
        return $this->officialVersion;
    }
    /**
     * Set officialVersion value
     * @param int $officialVersion
     * @return \StructType\DocumentRef
     */
    public function setOfficialVersion($officialVersion = null)
    {
        // validation for constraint: int
        if (!is_null($officialVersion) && !is_numeric($officialVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($officialVersion)), __LINE__);
        }
        $this->officialVersion = $officialVersion;
        return $this;
    }
    /**
     * Get currentVersion value
     * @return int|null
     */
    public function getCurrentVersion()
    {
        return $this->currentVersion;
    }
    /**
     * Set currentVersion value
     * @param int $currentVersion
     * @return \StructType\DocumentRef
     */
    public function setCurrentVersion($currentVersion = null)
    {
        // validation for constraint: int
        if (!is_null($currentVersion) && !is_numeric($currentVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($currentVersion)), __LINE__);
        }
        $this->currentVersion = $currentVersion;
        return $this;
    }
    /**
     * Get versionNumber value
     * @return int|null
     */
    public function getVersionNumber()
    {
        return $this->versionNumber;
    }
    /**
     * Set versionNumber value
     * @param int $versionNumber
     * @return \StructType\DocumentRef
     */
    public function setVersionNumber($versionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($versionNumber) && !is_numeric($versionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($versionNumber)), __LINE__);
        }
        $this->versionNumber = $versionNumber;
        return $this;
    }
    /**
     * Get versionDescription value
     * @return string|null
     */
    public function getVersionDescription()
    {
        return $this->versionDescription;
    }
    /**
     * Set versionDescription value
     * @param string $versionDescription
     * @return \StructType\DocumentRef
     */
    public function setVersionDescription($versionDescription = null)
    {
        // validation for constraint: string
        if (!is_null($versionDescription) && !is_string($versionDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($versionDescription)), __LINE__);
        }
        $this->versionDescription = $versionDescription;
        return $this;
    }
    /**
     * Get fileSize value
     * @return int|null
     */
    public function getFileSize()
    {
        return $this->fileSize;
    }
    /**
     * Set fileSize value
     * @param int $fileSize
     * @return \StructType\DocumentRef
     */
    public function setFileSize($fileSize = null)
    {
        // validation for constraint: int
        if (!is_null($fileSize) && !is_numeric($fileSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($fileSize)), __LINE__);
        }
        $this->fileSize = $fileSize;
        return $this;
    }
    /**
     * Get acl value
     * @return \StructType\AccessControlList|null
     */
    public function getAcl()
    {
        return $this->acl;
    }
    /**
     * Set acl value
     * @param \StructType\AccessControlList $acl
     * @return \StructType\DocumentRef
     */
    public function setAcl(\StructType\AccessControlList $acl = null)
    {
        $this->acl = $acl;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DocumentRef
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
