<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentCustom StructType
 * @subpackage Structs
 */
class DocumentCustom extends Custom
{
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0 | 0
     * - documentation: The unique identifier is a application defined string to uniquely identify an item. The string can optionally consist of two parts. The first part identifies a unique existence of an item. The second part of the string optionally
     * specifies instance information. The first and second part of the ID are separated by an '@'. For this reason neither the first nor second part can contain an '@' symbol. To determine whether or not two items are the same item, the consumer of this
     * API should compare the first part of the ids of the two items (i.e. all of the id up to the @ symbol).
     * - pattern: [^@]+(@*)?
     * - type: xs:string
     * @var string
     */
    public $id;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:description
     * @var string
     */
    public $description;
    /**
     * The readOnly
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $readOnly;
    /**
     * The hidden
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $hidden;
    /**
     * The required
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $required;
    /**
     * The textCase
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $textCase;
    /**
     * The maximumLength
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $maximumLength;
    /**
     * The minimum
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $minimum;
    /**
     * The maximum
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $maximum;
    /**
     * The table
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\LookupTable
     */
    public $table;
    /**
     * The related
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\LookupTable[]
     */
    public $related;
    /**
     * Constructor method for DocumentCustom
     * @uses DocumentCustom::setId()
     * @uses DocumentCustom::setDescription()
     * @uses DocumentCustom::setReadOnly()
     * @uses DocumentCustom::setHidden()
     * @uses DocumentCustom::setRequired()
     * @uses DocumentCustom::setTextCase()
     * @uses DocumentCustom::setMaximumLength()
     * @uses DocumentCustom::setMinimum()
     * @uses DocumentCustom::setMaximum()
     * @uses DocumentCustom::setTable()
     * @uses DocumentCustom::setRelated()
     * @param string $id
     * @param string $description
     * @param bool $readOnly
     * @param bool $hidden
     * @param bool $required
     * @param string $textCase
     * @param int $maximumLength
     * @param int $minimum
     * @param int $maximum
     * @param \StructType\LookupTable $table
     * @param \StructType\LookupTable[] $related
     */
    public function __construct($id = null, $description = null, $readOnly = null, $hidden = null, $required = null, $textCase = null, $maximumLength = null, $minimum = null, $maximum = null, \StructType\LookupTable $table = null, array $related = array())
    {
        $this
            ->setId($id)
            ->setDescription($description)
            ->setReadOnly($readOnly)
            ->setHidden($hidden)
            ->setRequired($required)
            ->setTextCase($textCase)
            ->setMaximumLength($maximumLength)
            ->setMinimum($minimum)
            ->setMaximum($maximum)
            ->setTable($table)
            ->setRelated($related);
    }
    /**
     * Get id value
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\DocumentCustom
     */
    public function setId($id = null)
    {
        // validation for constraint: pattern
        if (is_scalar($id) && !preg_match('/[^@]+(@*)?/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[^@]+(@*)?", "%s" given', var_export($id, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\DocumentCustom
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get readOnly value
     * @return bool|null
     */
    public function getReadOnly()
    {
        return $this->readOnly;
    }
    /**
     * Set readOnly value
     * @param bool $readOnly
     * @return \StructType\DocumentCustom
     */
    public function setReadOnly($readOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($readOnly) && !is_bool($readOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($readOnly)), __LINE__);
        }
        $this->readOnly = $readOnly;
        return $this;
    }
    /**
     * Get hidden value
     * @return bool|null
     */
    public function getHidden()
    {
        return $this->hidden;
    }
    /**
     * Set hidden value
     * @param bool $hidden
     * @return \StructType\DocumentCustom
     */
    public function setHidden($hidden = null)
    {
        // validation for constraint: boolean
        if (!is_null($hidden) && !is_bool($hidden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hidden)), __LINE__);
        }
        $this->hidden = $hidden;
        return $this;
    }
    /**
     * Get required value
     * @return bool|null
     */
    public function getRequired()
    {
        return $this->required;
    }
    /**
     * Set required value
     * @param bool $required
     * @return \StructType\DocumentCustom
     */
    public function setRequired($required = null)
    {
        // validation for constraint: boolean
        if (!is_null($required) && !is_bool($required)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($required)), __LINE__);
        }
        $this->required = $required;
        return $this;
    }
    /**
     * Get textCase value
     * @return string|null
     */
    public function getTextCase()
    {
        return $this->textCase;
    }
    /**
     * Set textCase value
     * @uses \EnumType\TextCase::valueIsValid()
     * @uses \EnumType\TextCase::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $textCase
     * @return \StructType\DocumentCustom
     */
    public function setTextCase($textCase = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TextCase::valueIsValid($textCase)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $textCase, implode(', ', \EnumType\TextCase::getValidValues())), __LINE__);
        }
        $this->textCase = $textCase;
        return $this;
    }
    /**
     * Get maximumLength value
     * @return int|null
     */
    public function getMaximumLength()
    {
        return $this->maximumLength;
    }
    /**
     * Set maximumLength value
     * @param int $maximumLength
     * @return \StructType\DocumentCustom
     */
    public function setMaximumLength($maximumLength = null)
    {
        // validation for constraint: int
        if (!is_null($maximumLength) && !is_numeric($maximumLength)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maximumLength)), __LINE__);
        }
        $this->maximumLength = $maximumLength;
        return $this;
    }
    /**
     * Get minimum value
     * @return int|null
     */
    public function getMinimum()
    {
        return $this->minimum;
    }
    /**
     * Set minimum value
     * @param int $minimum
     * @return \StructType\DocumentCustom
     */
    public function setMinimum($minimum = null)
    {
        // validation for constraint: int
        if (!is_null($minimum) && !is_numeric($minimum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($minimum)), __LINE__);
        }
        $this->minimum = $minimum;
        return $this;
    }
    /**
     * Get maximum value
     * @return int|null
     */
    public function getMaximum()
    {
        return $this->maximum;
    }
    /**
     * Set maximum value
     * @param int $maximum
     * @return \StructType\DocumentCustom
     */
    public function setMaximum($maximum = null)
    {
        // validation for constraint: int
        if (!is_null($maximum) && !is_numeric($maximum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maximum)), __LINE__);
        }
        $this->maximum = $maximum;
        return $this;
    }
    /**
     * Get table value
     * @return \StructType\LookupTable|null
     */
    public function getTable()
    {
        return $this->table;
    }
    /**
     * Set table value
     * @param \StructType\LookupTable $table
     * @return \StructType\DocumentCustom
     */
    public function setTable(\StructType\LookupTable $table = null)
    {
        $this->table = $table;
        return $this;
    }
    /**
     * Get related value
     * @return \StructType\LookupTable[]|null
     */
    public function getRelated()
    {
        return $this->related;
    }
    /**
     * Set related value
     * @throws \InvalidArgumentException
     * @param \StructType\LookupTable[] $related
     * @return \StructType\DocumentCustom
     */
    public function setRelated(array $related = array())
    {
        foreach ($related as $documentCustomRelatedItem) {
            // validation for constraint: itemType
            if (!$documentCustomRelatedItem instanceof \StructType\LookupTable) {
                throw new \InvalidArgumentException(sprintf('The related property can only contain items of \StructType\LookupTable, "%s" given', is_object($documentCustomRelatedItem) ? get_class($documentCustomRelatedItem) : gettype($documentCustomRelatedItem)), __LINE__);
            }
        }
        $this->related = $related;
        return $this;
    }
    /**
     * Add item to related value
     * @throws \InvalidArgumentException
     * @param \StructType\LookupTable $item
     * @return \StructType\DocumentCustom
     */
    public function addToRelated(\StructType\LookupTable $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LookupTable) {
            throw new \InvalidArgumentException(sprintf('The related property can only contain items of \StructType\LookupTable, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->related[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DocumentCustom
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
