<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DiskSpaceUsage StructType
 * @subpackage Structs
 */
class DiskSpaceUsage extends AbstractStructBase
{
    /**
     * The maxSize
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $maxSize;
    /**
     * The threshold
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $threshold;
    /**
     * The used
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $used;
    /**
     * The inMB
     * @var bool
     */
    public $inMB;
    /**
     * Constructor method for DiskSpaceUsage
     * @uses DiskSpaceUsage::setMaxSize()
     * @uses DiskSpaceUsage::setThreshold()
     * @uses DiskSpaceUsage::setUsed()
     * @uses DiskSpaceUsage::setInMB()
     * @param int $maxSize
     * @param int $threshold
     * @param int $used
     * @param bool $inMB
     */
    public function __construct($maxSize = null, $threshold = null, $used = null, $inMB = null)
    {
        $this
            ->setMaxSize($maxSize)
            ->setThreshold($threshold)
            ->setUsed($used)
            ->setInMB($inMB);
    }
    /**
     * Get maxSize value
     * @return int|null
     */
    public function getMaxSize()
    {
        return $this->maxSize;
    }
    /**
     * Set maxSize value
     * @param int $maxSize
     * @return \StructType\DiskSpaceUsage
     */
    public function setMaxSize($maxSize = null)
    {
        // validation for constraint: int
        if (!is_null($maxSize) && !is_numeric($maxSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxSize)), __LINE__);
        }
        $this->maxSize = $maxSize;
        return $this;
    }
    /**
     * Get threshold value
     * @return int|null
     */
    public function getThreshold()
    {
        return $this->threshold;
    }
    /**
     * Set threshold value
     * @param int $threshold
     * @return \StructType\DiskSpaceUsage
     */
    public function setThreshold($threshold = null)
    {
        // validation for constraint: int
        if (!is_null($threshold) && !is_numeric($threshold)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($threshold)), __LINE__);
        }
        $this->threshold = $threshold;
        return $this;
    }
    /**
     * Get used value
     * @return int|null
     */
    public function getUsed()
    {
        return $this->used;
    }
    /**
     * Set used value
     * @param int $used
     * @return \StructType\DiskSpaceUsage
     */
    public function setUsed($used = null)
    {
        // validation for constraint: int
        if (!is_null($used) && !is_numeric($used)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($used)), __LINE__);
        }
        $this->used = $used;
        return $this;
    }
    /**
     * Get inMB value
     * @return bool|null
     */
    public function getInMB()
    {
        return $this->inMB;
    }
    /**
     * Set inMB value
     * @param bool $inMB
     * @return \StructType\DiskSpaceUsage
     */
    public function setInMB($inMB = null)
    {
        // validation for constraint: boolean
        if (!is_null($inMB) && !is_bool($inMB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($inMB)), __LINE__);
        }
        $this->inMB = $inMB;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DiskSpaceUsage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
