<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for delegateRequest StructType
 * @subpackage Structs
 */
class DelegateRequest extends AbstractStructBase
{
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - documentation: The unique identifier is a application defined string to uniquely identify an item. The string can optionally consist of two parts. The first part identifies a unique existence of an item. The second part of the string optionally
     * specifies instance information. The first and second part of the ID are separated by an '@'. For this reason neither the first nor second part can contain an '@' symbol. To determine whether or not two items are the same item, the consumer of this
     * API should compare the first part of the ids of the two items (i.e. all of the id up to the @ symbol).
     * - minOccurs: 0
     * - pattern: [^@]+(@*)?
     * - type: xs:string
     * @var string
     */
    public $id;
    /**
     * The commentToOrganizer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $commentToOrganizer;
    /**
     * The commentToDelegatee
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $commentToDelegatee;
    /**
     * The distribution
     * @var \StructType\Distribution
     */
    public $distribution;
    /**
     * The recurrenceAllInstances
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $recurrenceAllInstances;
    /**
     * The attachments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AttachmentInfo
     */
    public $attachments;
    /**
     * The link
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\LinkInfo
     */
    public $link;
    /**
     * Constructor method for delegateRequest
     * @uses DelegateRequest::setId()
     * @uses DelegateRequest::setCommentToOrganizer()
     * @uses DelegateRequest::setCommentToDelegatee()
     * @uses DelegateRequest::setDistribution()
     * @uses DelegateRequest::setRecurrenceAllInstances()
     * @uses DelegateRequest::setAttachments()
     * @uses DelegateRequest::setLink()
     * @param string $id
     * @param string $commentToOrganizer
     * @param string $commentToDelegatee
     * @param \StructType\Distribution $distribution
     * @param int $recurrenceAllInstances
     * @param \StructType\AttachmentInfo $attachments
     * @param \StructType\LinkInfo $link
     */
    public function __construct($id = null, $commentToOrganizer = null, $commentToDelegatee = null, \StructType\Distribution $distribution = null, $recurrenceAllInstances = null, \StructType\AttachmentInfo $attachments = null, \StructType\LinkInfo $link = null)
    {
        $this
            ->setId($id)
            ->setCommentToOrganizer($commentToOrganizer)
            ->setCommentToDelegatee($commentToDelegatee)
            ->setDistribution($distribution)
            ->setRecurrenceAllInstances($recurrenceAllInstances)
            ->setAttachments($attachments)
            ->setLink($link);
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\DelegateRequest
     */
    public function setId($id = null)
    {
        // validation for constraint: pattern
        if (is_scalar($id) && !preg_match('/[^@]+(@*)?/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[^@]+(@*)?", "%s" given', var_export($id, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get commentToOrganizer value
     * @return string|null
     */
    public function getCommentToOrganizer()
    {
        return $this->commentToOrganizer;
    }
    /**
     * Set commentToOrganizer value
     * @param string $commentToOrganizer
     * @return \StructType\DelegateRequest
     */
    public function setCommentToOrganizer($commentToOrganizer = null)
    {
        // validation for constraint: string
        if (!is_null($commentToOrganizer) && !is_string($commentToOrganizer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($commentToOrganizer)), __LINE__);
        }
        $this->commentToOrganizer = $commentToOrganizer;
        return $this;
    }
    /**
     * Get commentToDelegatee value
     * @return string|null
     */
    public function getCommentToDelegatee()
    {
        return $this->commentToDelegatee;
    }
    /**
     * Set commentToDelegatee value
     * @param string $commentToDelegatee
     * @return \StructType\DelegateRequest
     */
    public function setCommentToDelegatee($commentToDelegatee = null)
    {
        // validation for constraint: string
        if (!is_null($commentToDelegatee) && !is_string($commentToDelegatee)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($commentToDelegatee)), __LINE__);
        }
        $this->commentToDelegatee = $commentToDelegatee;
        return $this;
    }
    /**
     * Get distribution value
     * @return \StructType\Distribution|null
     */
    public function getDistribution()
    {
        return $this->distribution;
    }
    /**
     * Set distribution value
     * @param \StructType\Distribution $distribution
     * @return \StructType\DelegateRequest
     */
    public function setDistribution(\StructType\Distribution $distribution = null)
    {
        $this->distribution = $distribution;
        return $this;
    }
    /**
     * Get recurrenceAllInstances value
     * @return int|null
     */
    public function getRecurrenceAllInstances()
    {
        return $this->recurrenceAllInstances;
    }
    /**
     * Set recurrenceAllInstances value
     * @param int $recurrenceAllInstances
     * @return \StructType\DelegateRequest
     */
    public function setRecurrenceAllInstances($recurrenceAllInstances = null)
    {
        // validation for constraint: int
        if (!is_null($recurrenceAllInstances) && !is_numeric($recurrenceAllInstances)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($recurrenceAllInstances)), __LINE__);
        }
        $this->recurrenceAllInstances = $recurrenceAllInstances;
        return $this;
    }
    /**
     * Get attachments value
     * @return \StructType\AttachmentInfo|null
     */
    public function getAttachments()
    {
        return $this->attachments;
    }
    /**
     * Set attachments value
     * @param \StructType\AttachmentInfo $attachments
     * @return \StructType\DelegateRequest
     */
    public function setAttachments(\StructType\AttachmentInfo $attachments = null)
    {
        $this->attachments = $attachments;
        return $this;
    }
    /**
     * Get link value
     * @return \StructType\LinkInfo|null
     */
    public function getLink()
    {
        return $this->link;
    }
    /**
     * Set link value
     * @param \StructType\LinkInfo $link
     * @return \StructType\DelegateRequest
     */
    public function setLink(\StructType\LinkInfo $link = null)
    {
        $this->link = $link;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DelegateRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
