<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for declineRequest StructType
 * @subpackage Structs
 */
class DeclineRequest extends AbstractStructBase
{
    /**
     * The items
     * @var \StructType\ItemRefList
     */
    public $items;
    /**
     * The comment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $comment;
    /**
     * The recurrenceAllInstances
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $recurrenceAllInstances;
    /**
     * Constructor method for declineRequest
     * @uses DeclineRequest::setItems()
     * @uses DeclineRequest::setComment()
     * @uses DeclineRequest::setRecurrenceAllInstances()
     * @param \StructType\ItemRefList $items
     * @param string $comment
     * @param int $recurrenceAllInstances
     */
    public function __construct(\StructType\ItemRefList $items = null, $comment = null, $recurrenceAllInstances = null)
    {
        $this
            ->setItems($items)
            ->setComment($comment)
            ->setRecurrenceAllInstances($recurrenceAllInstances);
    }
    /**
     * Get items value
     * @return \StructType\ItemRefList|null
     */
    public function getItems()
    {
        return $this->items;
    }
    /**
     * Set items value
     * @param \StructType\ItemRefList $items
     * @return \StructType\DeclineRequest
     */
    public function setItems(\StructType\ItemRefList $items = null)
    {
        $this->items = $items;
        return $this;
    }
    /**
     * Get comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->comment;
    }
    /**
     * Set comment value
     * @param string $comment
     * @return \StructType\DeclineRequest
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($comment)), __LINE__);
        }
        $this->comment = $comment;
        return $this;
    }
    /**
     * Get recurrenceAllInstances value
     * @return int|null
     */
    public function getRecurrenceAllInstances()
    {
        return $this->recurrenceAllInstances;
    }
    /**
     * Set recurrenceAllInstances value
     * @param int $recurrenceAllInstances
     * @return \StructType\DeclineRequest
     */
    public function setRecurrenceAllInstances($recurrenceAllInstances = null)
    {
        // validation for constraint: int
        if (!is_null($recurrenceAllInstances) && !is_numeric($recurrenceAllInstances)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($recurrenceAllInstances)), __LINE__);
        }
        $this->recurrenceAllInstances = $recurrenceAllInstances;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DeclineRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
