<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DayOfYearWeek StructType
 * @subpackage Structs
 */
class DayOfYearWeek extends \EnumType\WeekDay
{
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The occurrence
     * Meta informations extracted from the WSDL
     * - maxInclusive: 53
     * - minInclusive: -53
     * @var int
     */
    public $occurrence;
    /**
     * Constructor method for DayOfYearWeek
     * @uses DayOfYearWeek::set_()
     * @uses DayOfYearWeek::setOccurrence()
     * @param string $_
     * @param int $occurrence
     */
    public function __construct($_ = null, $occurrence = null)
    {
        $this
            ->set_($_)
            ->setOccurrence($occurrence);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @uses \EnumType\WeekDay::valueIsValid()
     * @uses \EnumType\WeekDay::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $_
     * @return \StructType\DayOfYearWeek
     */
    public function set_($_ = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\WeekDay::valueIsValid($_)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $_, implode(', ', \EnumType\WeekDay::getValidValues())), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get occurrence value
     * @return int|null
     */
    public function getOccurrence()
    {
        return $this->occurrence;
    }
    /**
     * Set occurrence value
     * @param int $occurrence
     * @return \StructType\DayOfYearWeek
     */
    public function setOccurrence($occurrence = null)
    {
        // validation for constraint: maxInclusive
        if ($occurrence > 53) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 53, "%s" given', $occurrence), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($occurrence < -53) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -53, "%s" given', $occurrence), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($occurrence) && !is_numeric($occurrence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($occurrence)), __LINE__);
        }
        $this->occurrence = $occurrence;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DayOfYearWeek
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
