<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Custom StructType
 * @subpackage Structs
 */
class Custom extends AbstractStructBase
{
    /**
     * The field
     * @var string
     */
    public $field;
    /**
     * The value
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $value;
    /**
     * The notify
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ReturnNotificationOptions
     */
    public $notify;
    /**
     * The locked
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $locked;
    /**
     * The adminOnly
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $adminOnly;
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $type;
    /**
     * Constructor method for Custom
     * @uses Custom::setField()
     * @uses Custom::setValue()
     * @uses Custom::setNotify()
     * @uses Custom::setLocked()
     * @uses Custom::setAdminOnly()
     * @uses Custom::setType()
     * @param string $field
     * @param string $value
     * @param \StructType\ReturnNotificationOptions $notify
     * @param bool $locked
     * @param bool $adminOnly
     * @param string $type
     */
    public function __construct($field = null, $value = null, \StructType\ReturnNotificationOptions $notify = null, $locked = null, $adminOnly = null, $type = null)
    {
        $this
            ->setField($field)
            ->setValue($value)
            ->setNotify($notify)
            ->setLocked($locked)
            ->setAdminOnly($adminOnly)
            ->setType($type);
    }
    /**
     * Get field value
     * @return string|null
     */
    public function getField()
    {
        return $this->field;
    }
    /**
     * Set field value
     * @param string $field
     * @return \StructType\Custom
     */
    public function setField($field = null)
    {
        // validation for constraint: string
        if (!is_null($field) && !is_string($field)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($field)), __LINE__);
        }
        $this->field = $field;
        return $this;
    }
    /**
     * Get value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param string $value
     * @return \StructType\Custom
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Get notify value
     * @return \StructType\ReturnNotificationOptions|null
     */
    public function getNotify()
    {
        return $this->notify;
    }
    /**
     * Set notify value
     * @param \StructType\ReturnNotificationOptions $notify
     * @return \StructType\Custom
     */
    public function setNotify(\StructType\ReturnNotificationOptions $notify = null)
    {
        $this->notify = $notify;
        return $this;
    }
    /**
     * Get locked value
     * @return bool|null
     */
    public function getLocked()
    {
        return $this->locked;
    }
    /**
     * Set locked value
     * @param bool $locked
     * @return \StructType\Custom
     */
    public function setLocked($locked = null)
    {
        // validation for constraint: boolean
        if (!is_null($locked) && !is_bool($locked)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($locked)), __LINE__);
        }
        $this->locked = $locked;
        return $this;
    }
    /**
     * Get adminOnly value
     * @return bool|null
     */
    public function getAdminOnly()
    {
        return $this->adminOnly;
    }
    /**
     * Set adminOnly value
     * @param bool $adminOnly
     * @return \StructType\Custom
     */
    public function setAdminOnly($adminOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($adminOnly) && !is_bool($adminOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($adminOnly)), __LINE__);
        }
        $this->adminOnly = $adminOnly;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\CustomType::valueIsValid()
     * @uses \EnumType\CustomType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\Custom
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CustomType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\CustomType::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Custom
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
