<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createCursorResponse StructType
 * @subpackage Structs
 */
class CreateCursorResponse extends AbstractStructBase
{
    /**
     * The cursor
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $cursor;
    /**
     * The status
     * @var \StructType\Status
     */
    public $status;
    /**
     * Constructor method for createCursorResponse
     * @uses CreateCursorResponse::setCursor()
     * @uses CreateCursorResponse::setStatus()
     * @param int $cursor
     * @param \StructType\Status $status
     */
    public function __construct($cursor = null, \StructType\Status $status = null)
    {
        $this
            ->setCursor($cursor)
            ->setStatus($status);
    }
    /**
     * Get cursor value
     * @return int|null
     */
    public function getCursor()
    {
        return $this->cursor;
    }
    /**
     * Set cursor value
     * @param int $cursor
     * @return \StructType\CreateCursorResponse
     */
    public function setCursor($cursor = null)
    {
        // validation for constraint: int
        if (!is_null($cursor) && !is_numeric($cursor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($cursor)), __LINE__);
        }
        $this->cursor = $cursor;
        return $this;
    }
    /**
     * Get status value
     * @return \StructType\Status|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param \StructType\Status $status
     * @return \StructType\CreateCursorResponse
     */
    public function setStatus(\StructType\Status $status = null)
    {
        $this->status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateCursorResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
