<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContainerList StructType
 * @subpackage Structs
 */
class ContainerList extends AbstractStructBase
{
    /**
     * The container
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0 | 0
     * - documentation: The unique identifier is a application defined string to uniquely identify an item. The string can optionally consist of two parts. The first part identifies a unique existence of an item. The second part of the string optionally
     * specifies instance information. The first and second part of the ID are separated by an '@'. For this reason neither the first nor second part can contain an '@' symbol. To determine whether or not two items are the same item, the consumer of this
     * API should compare the first part of the ids of the two items (i.e. all of the id up to the @ symbol).
     * - pattern: [^@]+(@*)?
     * - type: xs:string
     * @var string[]
     */
    public $container;
    /**
     * The not
     * Meta informations extracted from the WSDL
     * - default: 0
     * @var bool
     */
    public $not;
    /**
     * Constructor method for ContainerList
     * @uses ContainerList::setContainer()
     * @uses ContainerList::setNot()
     * @param string[] $container
     * @param bool $not
     */
    public function __construct(array $container = array(), $not = false)
    {
        $this
            ->setContainer($container)
            ->setNot($not);
    }
    /**
     * Get container value
     * @return string[]
     */
    public function getContainer()
    {
        return $this->container;
    }
    /**
     * Set container value
     * @throws \InvalidArgumentException
     * @param string[] $container
     * @return \StructType\ContainerList
     */
    public function setContainer(array $container = array())
    {
        // validation for constraint: pattern
        if (is_scalar($container) && !preg_match('/[^@]+(@*)?/', $container)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[^@]+(@*)?", "%s" given', var_export($container, true)), __LINE__);
        }
        foreach ($container as $containerListContainerItem) {
            // validation for constraint: itemType
            if (!is_string($containerListContainerItem)) {
                throw new \InvalidArgumentException(sprintf('The container property can only contain items of string, "%s" given', is_object($containerListContainerItem) ? get_class($containerListContainerItem) : gettype($containerListContainerItem)), __LINE__);
            }
        }
        $this->container = $container;
        return $this;
    }
    /**
     * Add item to container value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\ContainerList
     */
    public function addToContainer($item)
    {
        // validation for constraint: pattern
        if (is_scalar($item) && !preg_match('/[^@]+(@*)?/', $item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[^@]+(@*)?", "%s" given', var_export($item, true)), __LINE__);
        }
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The container property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->container[] = $item;
        return $this;
    }
    /**
     * Get not value
     * @return bool|null
     */
    public function getNot()
    {
        return $this->not;
    }
    /**
     * Set not value
     * @param bool $not
     * @return \StructType\ContainerList
     */
    public function setNot($not = false)
    {
        // validation for constraint: boolean
        if (!is_null($not) && !is_bool($not)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($not)), __LINE__);
        }
        $this->not = $not;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ContainerList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
