<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContainerItem StructType
 * @subpackage Structs
 */
class ContainerItem extends Item
{
    /**
     * The container
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\ContainerRef[]
     */
    public $container;
    /**
     * The categories
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CategoryRefList
     */
    public $categories;
    /**
     * The created
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $created;
    /**
     * The customs
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomList
     */
    public $customs;
    /**
     * The contacts
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ContactRefList
     */
    public $contacts;
    /**
     * Constructor method for ContainerItem
     * @uses ContainerItem::setContainer()
     * @uses ContainerItem::setCategories()
     * @uses ContainerItem::setCreated()
     * @uses ContainerItem::setCustoms()
     * @uses ContainerItem::setContacts()
     * @param \StructType\ContainerRef[] $container
     * @param \StructType\CategoryRefList $categories
     * @param string $created
     * @param \StructType\CustomList $customs
     * @param \StructType\ContactRefList $contacts
     */
    public function __construct(array $container = array(), \StructType\CategoryRefList $categories = null, $created = null, \StructType\CustomList $customs = null, \StructType\ContactRefList $contacts = null)
    {
        $this
            ->setContainer($container)
            ->setCategories($categories)
            ->setCreated($created)
            ->setCustoms($customs)
            ->setContacts($contacts);
    }
    /**
     * Get container value
     * @return \StructType\ContainerRef[]
     */
    public function getContainer()
    {
        return $this->container;
    }
    /**
     * Set container value
     * @throws \InvalidArgumentException
     * @param \StructType\ContainerRef[] $container
     * @return \StructType\ContainerItem
     */
    public function setContainer(array $container = array())
    {
        foreach ($container as $containerItemContainerItem) {
            // validation for constraint: itemType
            if (!$containerItemContainerItem instanceof \StructType\ContainerRef) {
                throw new \InvalidArgumentException(sprintf('The container property can only contain items of \StructType\ContainerRef, "%s" given', is_object($containerItemContainerItem) ? get_class($containerItemContainerItem) : gettype($containerItemContainerItem)), __LINE__);
            }
        }
        $this->container = $container;
        return $this;
    }
    /**
     * Add item to container value
     * @throws \InvalidArgumentException
     * @param \StructType\ContainerRef $item
     * @return \StructType\ContainerItem
     */
    public function addToContainer(\StructType\ContainerRef $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContainerRef) {
            throw new \InvalidArgumentException(sprintf('The container property can only contain items of \StructType\ContainerRef, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->container[] = $item;
        return $this;
    }
    /**
     * Get categories value
     * @return \StructType\CategoryRefList|null
     */
    public function getCategories()
    {
        return $this->categories;
    }
    /**
     * Set categories value
     * @param \StructType\CategoryRefList $categories
     * @return \StructType\ContainerItem
     */
    public function setCategories(\StructType\CategoryRefList $categories = null)
    {
        $this->categories = $categories;
        return $this;
    }
    /**
     * Get created value
     * @return string|null
     */
    public function getCreated()
    {
        return $this->created;
    }
    /**
     * Set created value
     * @param string $created
     * @return \StructType\ContainerItem
     */
    public function setCreated($created = null)
    {
        // validation for constraint: string
        if (!is_null($created) && !is_string($created)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($created)), __LINE__);
        }
        $this->created = $created;
        return $this;
    }
    /**
     * Get customs value
     * @return \StructType\CustomList|null
     */
    public function getCustoms()
    {
        return $this->customs;
    }
    /**
     * Set customs value
     * @param \StructType\CustomList $customs
     * @return \StructType\ContainerItem
     */
    public function setCustoms(\StructType\CustomList $customs = null)
    {
        $this->customs = $customs;
        return $this;
    }
    /**
     * Get contacts value
     * @return \StructType\ContactRefList|null
     */
    public function getContacts()
    {
        return $this->contacts;
    }
    /**
     * Set contacts value
     * @param \StructType\ContactRefList $contacts
     * @return \StructType\ContainerItem
     */
    public function setContacts(\StructType\ContactRefList $contacts = null)
    {
        $this->contacts = $contacts;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ContainerItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
