<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContactFolder StructType
 * @subpackage Structs
 */
class ContactFolder extends SystemFolder
{
    /**
     * The addressBook
     * Meta informations extracted from the WSDL
     * - minOccurs: 0 | 0
     * - documentation: The unique identifier is a application defined string to uniquely identify an item. The string can optionally consist of two parts. The first part identifies a unique existence of an item. The second part of the string optionally
     * specifies instance information. The first and second part of the ID are separated by an '@'. For this reason neither the first nor second part can contain an '@' symbol. To determine whether or not two items are the same item, the consumer of this
     * API should compare the first part of the ids of the two items (i.e. all of the id up to the @ symbol).
     * - pattern: [^@]+(@*)?
     * - type: xs:string
     * @var string
     */
    public $addressBook;
    /**
     * Constructor method for ContactFolder
     * @uses ContactFolder::setAddressBook()
     * @param string $addressBook
     */
    public function __construct($addressBook = null)
    {
        $this
            ->setAddressBook($addressBook);
    }
    /**
     * Get addressBook value
     * @return string
     */
    public function getAddressBook()
    {
        return $this->addressBook;
    }
    /**
     * Set addressBook value
     * @param string $addressBook
     * @return \StructType\ContactFolder
     */
    public function setAddressBook($addressBook = null)
    {
        // validation for constraint: pattern
        if (is_scalar($addressBook) && !preg_match('/[^@]+(@*)?/', $addressBook)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[^@]+(@*)?", "%s" given', var_export($addressBook, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($addressBook) && !is_string($addressBook)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressBook)), __LINE__);
        }
        $this->addressBook = $addressBook;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ContactFolder
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
