<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ColumnSettings StructType
 * @subpackage Structs
 */
class ColumnSettings extends AbstractStructBase
{
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $type;
    /**
     * The sort
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Sort
     */
    public $sort;
    /**
     * The headers
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Header[]
     */
    public $headers;
    /**
     * Constructor method for ColumnSettings
     * @uses ColumnSettings::setType()
     * @uses ColumnSettings::setSort()
     * @uses ColumnSettings::setHeaders()
     * @param string $type
     * @param \StructType\Sort $sort
     * @param \StructType\Header[] $headers
     */
    public function __construct($type = null, \StructType\Sort $sort = null, array $headers = array())
    {
        $this
            ->setType($type)
            ->setSort($sort)
            ->setHeaders($headers);
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\ColumnType::valueIsValid()
     * @uses \EnumType\ColumnType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\ColumnSettings
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ColumnType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\ColumnType::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get sort value
     * @return \StructType\Sort|null
     */
    public function getSort()
    {
        return $this->sort;
    }
    /**
     * Set sort value
     * @param \StructType\Sort $sort
     * @return \StructType\ColumnSettings
     */
    public function setSort(\StructType\Sort $sort = null)
    {
        $this->sort = $sort;
        return $this;
    }
    /**
     * Get headers value
     * @return \StructType\Header[]|null
     */
    public function getHeaders()
    {
        return $this->headers;
    }
    /**
     * Set headers value
     * @throws \InvalidArgumentException
     * @param \StructType\Header[] $headers
     * @return \StructType\ColumnSettings
     */
    public function setHeaders(array $headers = array())
    {
        foreach ($headers as $columnSettingsHeadersItem) {
            // validation for constraint: itemType
            if (!$columnSettingsHeadersItem instanceof \StructType\Header) {
                throw new \InvalidArgumentException(sprintf('The headers property can only contain items of \StructType\Header, "%s" given', is_object($columnSettingsHeadersItem) ? get_class($columnSettingsHeadersItem) : gettype($columnSettingsHeadersItem)), __LINE__);
            }
        }
        $this->headers = $headers;
        return $this;
    }
    /**
     * Add item to headers value
     * @throws \InvalidArgumentException
     * @param \StructType\Header $item
     * @return \StructType\ColumnSettings
     */
    public function addToHeaders(\StructType\Header $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Header) {
            throw new \InvalidArgumentException(sprintf('The headers property can only contain items of \StructType\Header, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->headers[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ColumnSettings
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
