<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChecklistInfo StructType
 * Meta informations extracted from the WSDL
 * - minOccurs: 0
 * - type: xs:unsignedInt
 * @subpackage Structs
 */
class ChecklistInfo extends AbstractStructBase
{
    /**
     * The sequence
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:sequence
     * @var int
     */
    public $sequence;
    /**
     * The dueDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dueDate;
    /**
     * The percentComplete
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $percentComplete;
    /**
     * The completed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $completed;
    /**
     * The thread
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $thread;
    /**
     * Constructor method for ChecklistInfo
     * @uses ChecklistInfo::setSequence()
     * @uses ChecklistInfo::setDueDate()
     * @uses ChecklistInfo::setPercentComplete()
     * @uses ChecklistInfo::setCompleted()
     * @uses ChecklistInfo::setThread()
     * @param int $sequence
     * @param string $dueDate
     * @param int $percentComplete
     * @param string $completed
     * @param string $thread
     */
    public function __construct($sequence = null, $dueDate = null, $percentComplete = null, $completed = null, $thread = null)
    {
        $this
            ->setSequence($sequence)
            ->setDueDate($dueDate)
            ->setPercentComplete($percentComplete)
            ->setCompleted($completed)
            ->setThread($thread);
    }
    /**
     * Get sequence value
     * @return int|null
     */
    public function getSequence()
    {
        return $this->sequence;
    }
    /**
     * Set sequence value
     * @param int $sequence
     * @return \StructType\ChecklistInfo
     */
    public function setSequence($sequence = null)
    {
        // validation for constraint: int
        if (!is_null($sequence) && !is_numeric($sequence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sequence)), __LINE__);
        }
        $this->sequence = $sequence;
        return $this;
    }
    /**
     * Get dueDate value
     * @return string|null
     */
    public function getDueDate()
    {
        return $this->dueDate;
    }
    /**
     * Set dueDate value
     * @param string $dueDate
     * @return \StructType\ChecklistInfo
     */
    public function setDueDate($dueDate = null)
    {
        // validation for constraint: string
        if (!is_null($dueDate) && !is_string($dueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dueDate)), __LINE__);
        }
        $this->dueDate = $dueDate;
        return $this;
    }
    /**
     * Get percentComplete value
     * @return int|null
     */
    public function getPercentComplete()
    {
        return $this->percentComplete;
    }
    /**
     * Set percentComplete value
     * @param int $percentComplete
     * @return \StructType\ChecklistInfo
     */
    public function setPercentComplete($percentComplete = null)
    {
        // validation for constraint: int
        if (!is_null($percentComplete) && !is_numeric($percentComplete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($percentComplete)), __LINE__);
        }
        $this->percentComplete = $percentComplete;
        return $this;
    }
    /**
     * Get completed value
     * @return string|null
     */
    public function getCompleted()
    {
        return $this->completed;
    }
    /**
     * Set completed value
     * @param string $completed
     * @return \StructType\ChecklistInfo
     */
    public function setCompleted($completed = null)
    {
        // validation for constraint: string
        if (!is_null($completed) && !is_string($completed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($completed)), __LINE__);
        }
        $this->completed = $completed;
        return $this;
    }
    /**
     * Get thread value
     * @return string|null
     */
    public function getThread()
    {
        return $this->thread;
    }
    /**
     * Set thread value
     * @param string $thread
     * @return \StructType\ChecklistInfo
     */
    public function setThread($thread = null)
    {
        // validation for constraint: string
        if (!is_null($thread) && !is_string($thread)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($thread)), __LINE__);
        }
        $this->thread = $thread;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ChecklistInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
