<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CategoryList StructType
 * @subpackage Structs
 */
class CategoryList extends AbstractStructBase
{
    /**
     * The category
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Category[]
     */
    public $category;
    /**
     * Constructor method for CategoryList
     * @uses CategoryList::setCategory()
     * @param \StructType\Category[] $category
     */
    public function __construct(array $category = array())
    {
        $this
            ->setCategory($category);
    }
    /**
     * Get category value
     * @return \StructType\Category[]|null
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * Set category value
     * @throws \InvalidArgumentException
     * @param \StructType\Category[] $category
     * @return \StructType\CategoryList
     */
    public function setCategory(array $category = array())
    {
        foreach ($category as $categoryListCategoryItem) {
            // validation for constraint: itemType
            if (!$categoryListCategoryItem instanceof \StructType\Category) {
                throw new \InvalidArgumentException(sprintf('The category property can only contain items of \StructType\Category, "%s" given', is_object($categoryListCategoryItem) ? get_class($categoryListCategoryItem) : gettype($categoryListCategoryItem)), __LINE__);
            }
        }
        $this->category = $category;
        return $this;
    }
    /**
     * Add item to category value
     * @throws \InvalidArgumentException
     * @param \StructType\Category $item
     * @return \StructType\CategoryList
     */
    public function addToCategory(\StructType\Category $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Category) {
            throw new \InvalidArgumentException(sprintf('The category property can only contain items of \StructType\Category, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->category[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CategoryList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
